/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.util;

import org.eclipse.glsp.graph.GBounds;
import org.eclipse.glsp.graph.GDimension;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.GraphFactory;

public final class GraphUtil {
    private GraphUtil() {
    }

    public static GBounds bounds(double x, double y, double width, double height) {
        GBounds bounds = GraphFactory.eINSTANCE.createGBounds();
        bounds.setX(x);
        bounds.setY(y);
        bounds.setWidth(width);
        bounds.setHeight(height);
        return bounds;
    }

    public static GBounds copy(GBounds toCopy) {
        return GraphUtil.bounds(toCopy.getX(), toCopy.getY(), toCopy.getWidth(), toCopy.getHeight());
    }

    public static GPoint point(double x, double y) {
        GPoint point = GraphFactory.eINSTANCE.createGPoint();
        point.setX(x);
        point.setY(y);
        return point;
    }

    public static GPoint copy(GPoint toCopy) {
        return GraphUtil.point(toCopy.getX(), toCopy.getY());
    }

    public static int compare(GPoint left, GPoint right) {
        int xCompare = Double.compare(left.getX(), right.getX());
        return xCompare != 0 ? xCompare : Double.compare(left.getY(), right.getY());
    }

    public static boolean equals(GPoint left, GPoint right) {
        return GraphUtil.compare(left, right) == 0;
    }

    public static GDimension dimension(double width, double height) {
        GDimension dimension = GraphFactory.eINSTANCE.createGDimension();
        dimension.setWidth(width);
        dimension.setHeight(height);
        return dimension;
    }

    public static GDimension copy(GDimension toCopy) {
        return GraphUtil.dimension(toCopy.getWidth(), toCopy.getHeight());
    }

    public static int compare(GDimension left, GDimension right) {
        int widthCompare = Double.compare(left.getWidth(), right.getWidth());
        return widthCompare != 0 ? widthCompare : Double.compare(left.getHeight(), right.getHeight());
    }

    public static boolean equals(GDimension left, GDimension right) {
        return GraphUtil.compare(left, right) == 0;
    }
}

