/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.emf;

import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.impl.GModelIndexImpl;
import org.eclipse.glsp.graph.util.RootAdapterUtil;
import org.eclipse.glsp.server.emf.EMFIdGenerator;
import org.eclipse.glsp.server.utils.BiIndex;

public class EMFModelIndex
extends GModelIndexImpl {
    protected EMFIdGenerator idGenerator;
    protected BiIndex<String, EObject> eObjectIndex = new BiIndex();

    protected EMFModelIndex(EObject target, EMFIdGenerator idGenerator) {
        super(target);
        this.idGenerator = idGenerator;
    }

    public boolean isAdapterForType(Object type) {
        return super.isAdapterForType(type) || EMFModelIndex.class.equals(type);
    }

    public void clear() {
        super.clear();
        this.eObjectIndex.clear();
    }

    public String indexEObject(EObject element) {
        String id = this.getOrCreateId(element);
        this.eObjectIndex.putIfAbsent((Object)id, (Object)element);
        return id;
    }

    protected String getOrCreateId(EObject element) {
        return this.idGenerator.getOrCreateId(element);
    }

    public Optional<EObject> getEObject(String id) {
        return Optional.ofNullable((EObject)this.eObjectIndex.get((Object)id));
    }

    public <T extends EObject> Optional<T> getEObject(String id, Class<T> clazz) {
        return this.safeCast(Optional.ofNullable((EObject)this.eObjectIndex.get((Object)id)), clazz);
    }

    public Optional<EObject> getEObject(GModelElement gModelElement) {
        return this.getEObject(gModelElement.getId());
    }

    public <T extends EObject> Optional<T> getEObject(GModelElement gModelElement, Class<T> clazz) {
        return this.getEObject(gModelElement.getId(), clazz);
    }

    protected <T> Optional<T> safeCast(Optional<?> toCast, Class<T> clazz) {
        return toCast.filter(clazz::isInstance).map(clazz::cast);
    }

    public static EMFModelIndex getOrCreate(GModelElement element, EMFIdGenerator idGenerator) {
        return (EMFModelIndex)RootAdapterUtil.getOrCreate((EObject)element, root -> new EMFModelIndex((EObject)root, idGenerator), EMFModelIndex.class);
    }
}

