/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.emf.notation;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.server.emf.EMFModelStateImpl;
import org.eclipse.glsp.server.emf.model.notation.Diagram;
import org.eclipse.glsp.server.emf.notation.EMFNotationModelIndex;
import org.eclipse.glsp.server.emf.notation.EMFNotationModelState;
import org.eclipse.glsp.server.emf.notation.EMFSemanticIdConverter;
import org.eclipse.glsp.server.session.ClientSession;

@Singleton
public class EMFNotationModelStateImpl
extends EMFModelStateImpl
implements EMFNotationModelState {
    protected Diagram notationModel;
    protected EObject semanticModel;
    @Inject
    protected EMFSemanticIdConverter semanticIdConverter;

    @Override
    protected GModelIndex getOrUpdateIndex(GModelRoot newRoot) {
        return EMFNotationModelIndex.getOrCreate((GModelElement)this.getRoot(), this.semanticIdConverter);
    }

    @Override
    public EMFNotationModelIndex getIndex() {
        return (EMFNotationModelIndex)super.getIndex();
    }

    @Override
    public void setSemanticModel(EObject semanticModel) {
        this.semanticModel = semanticModel;
    }

    @Override
    public EObject getSemanticModel() {
        return this.semanticModel;
    }

    @Override
    public <T extends EObject> Optional<T> getSemanticModel(Class<T> clazz) {
        return Optional.ofNullable(this.semanticModel).filter(clazz::isInstance).map(clazz::cast);
    }

    @Override
    public void setNotationModel(Diagram notationModel) {
        this.notationModel = notationModel;
    }

    @Override
    public Diagram getNotationModel() {
        return this.notationModel;
    }

    @Override
    public <T extends Diagram> Optional<T> getNotationModel(Class<T> clazz) {
        return Optional.ofNullable(this.notationModel).filter(clazz::isInstance).map(clazz::cast);
    }

    @Override
    public void sessionDisposed(ClientSession clientSession) {
        this.semanticModel = null;
        this.notationModel = null;
        super.sessionDisposed(clientSession);
    }
}

