/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.common.pluggability.util;

import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.pluggability.util.LogRecordEntry;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.SequenceInputStream;
import java.util.Collection;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogFileProcessor {
    private String logFileLocation = null;
    private Collection recordCollection = null;
    private Collection appIdRecordCollection = null;
    private Collection appSpecificRecordCollection = null;

    public LogFileProcessor(Properties props) {
        this.setup(props);
    }

    public void setup(Properties props) {
        TestUtil.logTrace((String)"LogFileProcessor setup started");
        String defaultedLogLocation = System.getProperty("log.file.location.defaulted");
        this.logFileLocation = props.getProperty("log.file.location");
        if (defaultedLogLocation != null) {
            this.logFileLocation = defaultedLogLocation;
        } else {
            if (this.logFileLocation == null) {
                TestUtil.logErr((String)"LogFileProcessor setup failed ");
                TestUtil.logErr((String)"Please verify that the property log.file.location exists in ts.jte");
                throw new IllegalArgumentException("Configure log.file.location in your ts.jte");
            }
            TestUtil.logMsg((String)("log.file.location = " + this.logFileLocation));
            this.logFileLocation = this.getLogFileName(this.logFileLocation);
        }
        TestUtil.logTrace((String)"LogFileProcessor setup finished");
    }

    public long getCurrentSequenceNumber() {
        LogRecordEntry recordEntry2 = null;
        long seqNum = 0L;
        TestUtil.logTrace((String)"Searching for current Sequence Number");
        if (this.recordCollection != null) {
            TestUtil.logTrace((String)("Record collection has:  " + this.recordCollection.size() + " records."));
            for (LogRecordEntry recordEntry2 : this.recordCollection) {
                seqNum = recordEntry2.getSequenceNumber();
            }
        } else {
            TestUtil.logErr((String)"Record collection empty : No log records found");
        }
        return seqNum;
    }

    public void purgeLog() {
        File logfile = null;
        try {
            if (this.logFileLocation != null) {
                logfile = new File(this.logFileLocation);
            }
            if (this.logFileLocation == null || !logfile.exists()) {
                TestUtil.logErr((String)("Log File : " + this.logFileLocation + " does not exists"));
            } else {
                TestUtil.logTrace((String)("Purging log file : " + this.logFileLocation));
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.logFileLocation));
                writer.newLine();
                writer.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred while purging log:" + e));
        }
    }

    public boolean fetchLog() {
        boolean logRetrieved = false;
        File logfile = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (this.logFileLocation != null) {
                logfile = new File(this.logFileLocation);
            }
            if (this.logFileLocation == null || !logfile.exists()) {
                TestUtil.logErr((String)("Log File : " + this.logFileLocation + " does not exists"));
                TestUtil.logErr((String)"Check permissions for log file ");
                TestUtil.logErr((String)"See User guide for Configuring log file permissions");
            } else {
                TestUtil.logTrace((String)("Log File : " + logfile.getAbsolutePath()));
                String endLogTag = "</log>";
                ByteArrayInputStream bais = new ByteArrayInputStream(endLogTag.getBytes());
                SequenceInputStream sis = new SequenceInputStream(new FileInputStream(this.logFileLocation), bais);
                Document document = documentBuilder.parse(sis);
                Element rootElement = document.getDocumentElement();
                NodeList nodes = rootElement.getChildNodes();
                this.recordCollection = LogFileProcessor.pullAllLogRecords(nodes);
                logRetrieved = true;
                sis.close();
                bais.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred while fetching log:" + e));
        }
        return logRetrieved;
    }

    public static Collection pullAllLogRecords(NodeList nodes) throws Exception {
        Vector<LogRecordEntry> recordCollection = new Vector<LogRecordEntry>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node recordNode = nodes.item(i);
            if (!recordNode.getNodeName().equals("record")) continue;
            LogRecordEntry recordEntry = new LogRecordEntry(recordNode);
            recordCollection.add(recordEntry);
        }
        return recordCollection;
    }

    public void setAppIdRecordCollection(Collection recordCollection) {
        this.appIdRecordCollection = recordCollection;
    }

    public Collection getAppIdRecordCollection() {
        return this.appIdRecordCollection;
    }

    public void setRecordCollection(Collection recordCollection) {
        this.recordCollection = recordCollection;
    }

    public Collection getRecordCollection() {
        return this.recordCollection;
    }

    public void setAppSpecificRecordCollection(Collection recordCollection) {
        this.appSpecificRecordCollection = recordCollection;
    }

    public Collection getAppSpecificRecordCollection() {
        return this.appSpecificRecordCollection;
    }

    public boolean verifyLogContains(String[] args) {
        return this.verifyLogContains(args, 0L);
    }

    public boolean verifyLogContains(String[] args, long sequenceNum) {
        LogRecordEntry recordEntry2 = null;
        TestUtil.logTrace((String)"Searching log records for the following:");
        for (String s : args) {
            TestUtil.logTrace((String)("item:" + s));
        }
        if (this.recordCollection == null) {
            TestUtil.logTrace((String)"Record collection empty : No log records found");
            return false;
        }
        TestUtil.logTrace((String)("Record collection has:  " + this.recordCollection.size() + " records."));
        int numberOfArgs = args.length;
        int numberOfMatches = 0;
        boolean[] argsMatchIndex = new boolean[args.length];
        for (int i = 0; i < args.length; ++i) {
            argsMatchIndex[i] = false;
        }
        for (LogRecordEntry recordEntry2 : this.recordCollection) {
            long seqNum = recordEntry2.getSequenceNumber();
            if (seqNum < sequenceNum) continue;
            String message = recordEntry2.getMessage();
            for (int i = 0; i < numberOfArgs; ++i) {
                if (argsMatchIndex[i] || message == null || !message.equals(args[i])) continue;
                TestUtil.logTrace((String)"Matching Record :");
                TestUtil.logTrace((String)(recordEntry2.getSequenceNumber() + ":" + recordEntry2.getMessage()));
                ++numberOfMatches;
                argsMatchIndex[i] = true;
            }
            if (numberOfMatches != numberOfArgs) continue;
            return true;
        }
        TestUtil.logTrace((String)"No Matching log Record(s) found for the following String(s) :");
        for (int i = 0; i < numberOfArgs; ++i) {
            if (argsMatchIndex[i]) continue;
            TestUtil.logTrace((String)args[i]);
        }
        return false;
    }

    public boolean verifyLogContainsOneOf(String[] args) {
        LogRecordEntry recordEntry2 = null;
        boolean result = false;
        TestUtil.logTrace((String)"Searching log records for one of the following:");
        for (String s : args) {
            TestUtil.logTrace((String)("item:" + s));
        }
        if (this.recordCollection == null) {
            TestUtil.logTrace((String)"Record collection empty : No log records found");
            return false;
        }
        TestUtil.logTrace((String)("Record collection has:  " + this.recordCollection.size() + " records."));
        int numberOfArgs = args.length;
        block1: for (LogRecordEntry recordEntry2 : this.recordCollection) {
            String message = recordEntry2.getMessage();
            for (int i = 0; i < numberOfArgs; ++i) {
                if (message == null || !message.equals(args[i])) continue;
                TestUtil.logTrace((String)"Matching Record :");
                TestUtil.logTrace((String)(recordEntry2.getSequenceNumber() + ":" + recordEntry2.getMessage()));
                result = true;
                break block1;
            }
        }
        if (!result) {
            TestUtil.logTrace((String)"No Matching log Record(s) found for the following String(s) :");
            for (int i = 0; i < numberOfArgs; ++i) {
                TestUtil.logTrace((String)args[i]);
            }
        }
        return result;
    }

    public boolean verifyLogContainsOneOfSubString(String[] args, String srchStrPrefix) {
        LogRecordEntry recordEntry2 = null;
        boolean result = false;
        TestUtil.logTrace((String)"Searching log records for the presence of one of the String from a given string array");
        if (this.recordCollection == null) {
            TestUtil.logTrace((String)"Record collection empty : No log records found");
            return false;
        }
        TestUtil.logTrace((String)("Record collection has:  " + this.recordCollection.size() + " records."));
        int numberOfArgs = args.length;
        block0: for (LogRecordEntry recordEntry2 : this.recordCollection) {
            String message = recordEntry2.getMessage();
            for (int i = 0; i < numberOfArgs; ++i) {
                if (message == null || !message.startsWith(srchStrPrefix, 0) || message.indexOf(args[i]) <= 0) continue;
                TestUtil.logTrace((String)"Matching Record :");
                TestUtil.logTrace((String)recordEntry2.getMessage());
                result = true;
                break block0;
            }
        }
        if (!result) {
            TestUtil.logTrace((String)"No Matching log Record(s) found for the following String(s) :");
            for (int i = 0; i < numberOfArgs; ++i) {
                TestUtil.logTrace((String)args[i]);
            }
        }
        return result;
    }

    public void printCollection(Collection recordCollection) {
        LogRecordEntry recordEntry2 = null;
        for (LogRecordEntry recordEntry2 : recordCollection) {
            this.printRecordEntry(recordEntry2);
        }
    }

    public void printRecordEntry(LogRecordEntry rec) {
        TestUtil.logTrace((String)"*******Log Content*******");
        TestUtil.logTrace((String)("Milli Seconds  =" + rec.getMilliSeconds()));
        TestUtil.logTrace((String)("Seqence no  =" + rec.getSequenceNumber()));
        TestUtil.logTrace((String)("Message     =" + rec.getMessage()));
        if (rec.getClassName() != null) {
            TestUtil.logTrace((String)("Class name  =" + rec.getClassName()));
        }
        if (rec.getMethodName() != null) {
            TestUtil.logTrace((String)("Method name =" + rec.getMethodName()));
        }
        if (rec.getLevel() != null) {
            TestUtil.logTrace((String)("Level        =" + rec.getLevel()));
        }
        if (rec.getThrown() != null) {
            TestUtil.logTrace((String)("Thrown       =" + rec.getThrown()));
        }
        TestUtil.logTrace((String)"");
    }

    public String extractQueryToken(String str, String ContextId) {
        String DELIMETER = "|";
        String qstring = null;
        String qparams = null;
        StringTokenizer strtok = new StringTokenizer(ContextId, DELIMETER);
        if (ContextId.indexOf(DELIMETER) > 0) {
            qstring = strtok.nextToken();
            if (strtok.hasMoreTokens()) {
                qparams = strtok.nextToken();
            }
        }
        if (str.equals("LogQueryString")) {
            return qstring;
        }
        return qparams;
    }

    public static String[] getTokens(String str, String delimeter) {
        String[] array = new String[2];
        StringTokenizer strtoken = new StringTokenizer(str, delimeter);
        if (str.indexOf(delimeter) > 0) {
            array[0] = strtoken.nextToken();
            array[1] = str.substring(array[0].length() + 3, str.length());
        }
        return array;
    }

    public Collection findLogsByPrefix(String queryParams, NodeList nodes) throws Exception {
        Vector<LogRecordEntry> recordCollection = new Vector<LogRecordEntry>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node recordNode = nodes.item(i);
            NodeList recordNodeChildren = recordNode.getChildNodes();
            for (int j = 0; j < recordNodeChildren.getLength(); ++j) {
                String nodeValue;
                Node childNode = recordNodeChildren.item(j);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals("message") || !(nodeValue = this.getText(childNode)).startsWith(queryParams)) continue;
                LogRecordEntry recordEntry = new LogRecordEntry(recordNode);
                recordCollection.add(recordEntry);
            }
        }
        return recordCollection;
    }

    public String getText(Node textNode) {
        String result = "";
        NodeList nodes = textNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 3) continue;
            result = node.getNodeValue();
            break;
        }
        return result;
    }

    public String getLogFileName(String logFileLocation) {
        String logName = logFileLocation + File.separator + "JPALog.xml";
        String lastFileName = "JPALog.xml";
        int lastFileIndex = 0;
        File dir = new File(logFileLocation);
        if (dir.exists()) {
            TestUtil.logTrace((String)("log file location exists:" + logFileLocation));
            String[] chld = dir.list();
            if (chld == null) {
                TestUtil.logErr((String)"Appserver log directory does not exist or is not a directory, using default log file location.");
            } else {
                boolean found = false;
                for (int i = 0; i < chld.length; ++i) {
                    String fName = chld[i];
                    if (fName.indexOf("JPALog.xml") >= 0 && fName.indexOf(".lck") < 0) {
                        int lastFileIndexTemp;
                        String[] fileNameArr = fName.split("\\.");
                        if (fileNameArr.length == 3 && lastFileIndex < (lastFileIndexTemp = Integer.parseInt(fileNameArr[2]))) {
                            lastFileIndex = lastFileIndexTemp;
                            lastFileName = fName;
                        }
                        logName = logFileLocation + File.separator + lastFileName;
                        TestUtil.logMsg((String)("Found log file:" + logName));
                        found = true;
                        continue;
                    }
                    TestUtil.logTrace((String)("Ignoring file:" + fName));
                }
                if (!found) {
                    TestUtil.logMsg((String)("Log file not found, using default location:" + logName));
                }
            }
        } else {
            TestUtil.logErr((String)("Log file location DOES NOT exist, using default location:" + logName));
        }
        return logName;
    }
}

