/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.core.ssl.ConnectionSslOptions;
import org.eclipse.kura.core.ssl.SSLSocketFactoryWrapper;
import org.eclipse.kura.core.ssl.SslManagerServiceOptions;
import org.eclipse.kura.core.ssl.SslServiceListeners;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.ssl.SslManagerService;
import org.eclipse.kura.ssl.SslServiceListener;
import org.eclipse.kura.system.SystemService;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslManagerServiceImpl
implements SslManagerService,
ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(SslManagerServiceImpl.class);
    private SslServiceListeners sslServiceListeners;
    private ComponentContext ctx;
    private Map<String, Object> properties;
    private SslManagerServiceOptions options;
    private CryptoService cryptoService;
    private ConfigurationService configurationService;
    private ScheduledExecutorService selfUpdaterExecutor;
    private ScheduledFuture<?> selfUpdaterFuture;
    private Map<ConnectionSslOptions, SSLSocketFactory> sslSocketFactories;
    private SystemService systemService;

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void unsetCryptoService(CryptoService cryptoService) {
        this.cryptoService = null;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void unsetConfigurationService(ConfigurationService configurationService) {
        this.configurationService = null;
    }

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        this.systemService = null;
    }

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        logger.info("activate...");
        this.ctx = componentContext;
        this.properties = properties;
        this.options = new SslManagerServiceOptions(properties);
        this.sslSocketFactories = new ConcurrentHashMap<ConnectionSslOptions, SSLSocketFactory>();
        this.selfUpdaterExecutor = Executors.newSingleThreadScheduledExecutor();
        ServiceTracker listenersTracker = new ServiceTracker(componentContext.getBundleContext(), SslServiceListener.class, null);
        this.sslServiceListeners = new SslServiceListeners((ServiceTracker<SslServiceListener, SslServiceListener>)listenersTracker);
        this.accessKeystore();
    }

    public void updated(Map<String, Object> properties) {
        logger.info("updated...");
        this.properties = properties;
        this.options = new SslManagerServiceOptions(properties);
        this.sslSocketFactories = new ConcurrentHashMap<ConnectionSslOptions, SSLSocketFactory>();
        this.accessKeystore();
        this.sslServiceListeners.onConfigurationUpdated();
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("deactivate...");
        this.sslServiceListeners.close();
        if (this.selfUpdaterFuture != null && !this.selfUpdaterFuture.isDone()) {
            logger.info("Self updater task running. Stopping it");
            this.selfUpdaterFuture.cancel(true);
        }
    }

    public SSLSocketFactory getSSLSocketFactory() throws GeneralSecurityException, IOException {
        return this.getSSLSocketFactory("");
    }

    public SSLSocketFactory getSSLSocketFactory(String keyAlias) throws GeneralSecurityException, IOException {
        String protocol = this.options.getSslProtocol();
        String ciphers = this.options.getSslCiphers();
        String trustStore = this.options.getSslKeyStore();
        char[] keyStorePassword = this.getKeyStorePassword();
        boolean hostnameVerifcation = this.options.isSslHostnameVerification();
        return this.getSSLSocketFactory(protocol, ciphers, trustStore, trustStore, keyStorePassword, keyAlias, hostnameVerifcation);
    }

    public SSLSocketFactory getSSLSocketFactory(String protocol, String ciphers, String trustStore, String keyStore, char[] keyStorePassword, String keyAlias) throws GeneralSecurityException, IOException {
        return this.getSSLSocketFactory(protocol, ciphers, trustStore, keyStore, keyStorePassword, keyAlias, this.options.isSslHostnameVerification());
    }

    public SSLSocketFactory getSSLSocketFactory(String protocol, String ciphers, String trustStore, String keyStore, char[] keyStorePassword, String keyAlias, boolean hostnameVerification) throws GeneralSecurityException, IOException {
        ConnectionSslOptions connSslOpts = new ConnectionSslOptions(this.options);
        connSslOpts.setProtocol(protocol);
        connSslOpts.setCiphers(ciphers);
        connSslOpts.setTrustStore(trustStore);
        connSslOpts.setKeyStore(keyStore);
        if (keyStorePassword == null) {
            connSslOpts.setKeyStorePassword(this.getKeyStorePassword());
        } else {
            connSslOpts.setKeyStorePassword(keyStorePassword);
        }
        connSslOpts.setAlias(keyAlias);
        connSslOpts.setHostnameVerification(hostnameVerification);
        return this.getSSLSocketFactoryInternal(connSslOpts);
    }

    public X509Certificate[] getTrustCertificates() throws GeneralSecurityException, IOException {
        TrustManager[] tms;
        X509Certificate[] cacerts = null;
        String trustStore = this.options.getSslKeyStore();
        TrustManager[] trustManagerArray = tms = SslManagerServiceImpl.getTrustManagers(trustStore, this.options.getSslKeystorePassword().toCharArray());
        int n = tms.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager tm = trustManagerArray[n2];
            if (tm instanceof X509TrustManager) {
                X509TrustManager x509tm = (X509TrustManager)tm;
                cacerts = x509tm.getAcceptedIssuers();
                break;
            }
            ++n2;
        }
        return cacerts;
    }

    public void installTrustCertificate(String alias, X509Certificate x509crt) throws GeneralSecurityException, IOException {
        String keyStore = this.options.getSslKeyStore();
        char[] keyStorePassword = this.getKeyStorePassword();
        KeyStore ks = this.loadKeystore(keyStore, keyStorePassword);
        ks.setCertificateEntry(alias, x509crt);
        this.saveKeystore(keyStore, keyStorePassword, ks);
    }

    public void deleteTrustCertificate(String alias) throws GeneralSecurityException, IOException {
        String keyStore = this.options.getSslKeyStore();
        char[] keyStorePassword = this.getKeyStorePassword();
        KeyStore ks = this.loadKeystore(keyStore, keyStorePassword);
        ks.deleteEntry(alias);
        this.saveKeystore(keyStore, keyStorePassword, ks);
    }

    public void installPrivateKey(String alias, PrivateKey privateKey, char[] password, Certificate[] publicCerts) throws GeneralSecurityException, IOException {
        String keyStore = this.options.getSslKeyStore();
        char[] keyStorePassword = this.getKeyStorePassword();
        KeyStore ks = this.loadKeystore(keyStore, keyStorePassword);
        ks.setKeyEntry(alias, privateKey, keyStorePassword, publicCerts);
        this.saveKeystore(keyStore, keyStorePassword, ks);
    }

    private void saveKeystore(String keyStoreFileName, char[] keyStorePassword, KeyStore ks) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileOutputStream tsOutStream = new FileOutputStream(keyStoreFileName);){
            ks.store(tsOutStream, keyStorePassword);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private KeyStore loadKeystore(String keyStore, char[] keyStorePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream tsReadStream = new FileInputStream(keyStore);){
            ks.load(tsReadStream, keyStorePassword);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return ks;
    }

    private void accessKeystore() {
        String keystorePath = this.options.getSslKeyStore();
        File fKeyStore = new File(keystorePath);
        if (!fKeyStore.exists()) {
            return;
        }
        if (this.isFirstBoot()) {
            this.changeDefaultKeystorePassword();
        } else {
            char[] oldPassword = this.getOldKeystorePassword(keystorePath);
            char[] newPassword = null;
            try {
                newPassword = this.cryptoService.decryptAes(this.options.getSslKeystorePassword().toCharArray());
            }
            catch (KuraException kuraException) {
                logger.warn("Failed to decrypt keystore password");
            }
            if (!Arrays.equals(oldPassword, newPassword)) {
                this.updateKeystorePassword(oldPassword, newPassword);
            }
        }
    }

    private char[] getOldKeystorePassword(String keystorePath) {
        char[] password = this.cryptoService.getKeyStorePassword(keystorePath);
        if (password != null && this.isKeyStoreAccessible(this.options.getSslKeyStore(), password)) {
            return password;
        }
        try {
            password = this.cryptoService.decryptAes(this.options.getSslKeystorePassword().toCharArray());
        }
        catch (KuraException kuraException) {
            password = new char[]{};
        }
        return password;
    }

    private void updateKeystorePassword(char[] oldPassword, char[] newPassword) {
        try {
            this.changeKeyStorePassword(this.options.getSslKeyStore(), oldPassword, newPassword);
            this.cryptoService.setKeyStorePassword(this.options.getSslKeyStore(), newPassword);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException exception) {
            logger.warn("Failed to change keystore password");
        }
        catch (KuraException kuraException) {
            logger.warn("Failed to persist keystore password");
        }
    }

    private void changeDefaultKeystorePassword() {
        char[] oldPassword = this.systemService.getJavaKeyStorePassword();
        if (this.isDefaultFromCrypto()) {
            oldPassword = this.cryptoService.getKeyStorePassword(this.options.getSslKeyStore());
        }
        char[] newPassword = new BigInteger(160, new SecureRandom()).toString(32).toCharArray();
        try {
            this.changeKeyStorePassword(this.options.getSslKeyStore(), oldPassword, newPassword);
            this.cryptoService.setKeyStorePassword(this.options.getSslKeyStore(), newPassword);
            this.updatePasswordInConfigService(newPassword);
        }
        catch (Exception e) {
            logger.warn("Keystore password change failed", (Throwable)e);
        }
    }

    private void updatePasswordInConfigService(char[] newPassword) {
        final String pid = (String)this.properties.get("service.pid");
        final HashMap<String, Object> props = new HashMap<String, Object>(this.properties);
        props.put("ssl.keystore.password", new Password(newPassword));
        this.selfUpdaterFuture = this.selfUpdaterExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SslManagerServiceImpl.this.ctx.getServiceReference() != null && SslManagerServiceImpl.this.configurationService.getComponentConfiguration(pid) != null) {
                        SslManagerServiceImpl.this.configurationService.updateConfiguration(pid, props);
                        throw new RuntimeException("Updated. The task will be terminated.");
                    }
                    logger.info("No service or configuration available yet.");
                }
                catch (KuraException e) {
                    logger.warn("Cannot get/update configuration for pid: {}", (Object)pid, (Object)e);
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private boolean isFirstBoot() {
        boolean result = false;
        if (this.isSnapshotPasswordDefault() && (this.isDefaultFromUser() || this.isDefaultFromCrypto())) {
            result = true;
        }
        return result;
    }

    private boolean isSnapshotPasswordDefault() {
        boolean result = false;
        char[] snapshotPassword = this.getUnencryptedSslKeystorePassword();
        if (Arrays.equals("changeit".toCharArray(), snapshotPassword)) {
            result = true;
        }
        return result;
    }

    private char[] getUnencryptedSslKeystorePassword() {
        char[] snapshotPassword = this.options.getSslKeystorePassword().toCharArray();
        try {
            snapshotPassword = this.cryptoService.decryptAes(snapshotPassword);
        }
        catch (KuraException kuraException) {}
        return snapshotPassword;
    }

    private boolean isDefaultFromCrypto() {
        char[] cryptoPassword = this.cryptoService.getKeyStorePassword(this.options.getSslKeyStore());
        return this.isKeyStoreAccessible(this.options.getSslKeyStore(), cryptoPassword);
    }

    private boolean isDefaultFromUser() {
        return this.isKeyStoreAccessible(this.options.getSslKeyStore(), this.systemService.getJavaKeyStorePassword());
    }

    private SSLSocketFactory getSSLSocketFactoryInternal(ConnectionSslOptions options) throws GeneralSecurityException, IOException {
        SSLSocketFactory factory = this.sslSocketFactories.get(options);
        if (factory == null) {
            logger.info("Creating a new SSLSocketFactory instance");
            TrustManager[] tms = SslManagerServiceImpl.getTrustManagers(options.getTrustStore(), options.getKeyStorePassword());
            KeyManager[] kms = this.getKeyManagers(options.getKeyStore(), options.getKeyStorePassword(), options.getAlias());
            factory = SslManagerServiceImpl.createSSLSocketFactory(options.getProtocol(), options.getCiphers(), kms, tms, options.getHostnameVerification());
            this.sslSocketFactories.put(options, factory);
        }
        return factory;
    }

    private static SSLSocketFactory createSSLSocketFactory(String protocol, String ciphers, KeyManager[] kms, TrustManager[] tms, boolean hostnameVerification) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslCtx;
        if (protocol == null) {
            sslCtx = SSLContext.getDefault();
        } else {
            sslCtx = SSLContext.getInstance(protocol);
            sslCtx.init(kms, tms, null);
        }
        SSLSocketFactory sslSocketFactory = sslCtx.getSocketFactory();
        return new SSLSocketFactoryWrapper(sslSocketFactory, ciphers, hostnameVerification);
    }

    private static TrustManager[] getTrustManagers(String trustStore, char[] keyStorePassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        File fTrustStore;
        TrustManager[] result = new TrustManager[]{};
        TrustManagerFactory tmf = null;
        if (trustStore != null && (fTrustStore = new File(trustStore)).exists()) {
            KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
            FileInputStream tsReadStream = new FileInputStream(trustStore);
            ts.load(tsReadStream, keyStorePassword);
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            result = tmf.getTrustManagers();
            ((InputStream)tsReadStream).close();
        }
        return result;
    }

    private KeyManager[] getKeyManagers(String keyStore, char[] keyStorePassword, String keyAlias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException {
        KeyStore ks = this.getKeyStore(keyStore, keyStorePassword, keyAlias);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(ks, keyStorePassword);
        return kmf.getKeyManagers();
    }

    private KeyStore getKeyStore(String keyStore, char[] keyStorePassword, String keyAlias) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableEntryException {
        File fKeyStore = new File(keyStore);
        if (!fKeyStore.exists() || !this.isKeyStoreAccessible(keyStore, keyStorePassword)) {
            logger.warn("The referenced keystore does not exist or is not accessible");
            throw new KeyStoreException("The referenced keystore does not exist or is not accessible");
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileInputStream ksReadStream = new FileInputStream(keyStore);){
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(ksReadStream, keyStorePassword);
            if (ks.containsAlias(keyAlias) && ks.isKeyEntry(keyAlias)) {
                KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(keyStorePassword);
                KeyStore.Entry entry = ks.getEntry(keyAlias, pp);
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null, null);
                ks.setEntry(keyAlias, entry, pp);
            }
            return ks;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private char[] getKeyStorePassword() {
        return this.cryptoService.getKeyStorePassword(this.options.getSslKeyStore());
    }

    private boolean isKeyStoreAccessible(String location, char[] password) {
        try {
            this.loadKeystore(location, password);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void changeKeyStorePassword(String location, char[] oldPassword, char[] newPassword) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableEntryException {
        KeyStore keystore = this.loadKeystore(location, oldPassword);
        SslManagerServiceImpl.updateKeyEntiesPasswords(keystore, oldPassword, newPassword);
        this.saveKeystore(location, newPassword, keystore);
    }

    private static void updateKeyEntiesPasswords(KeyStore keystore, char[] oldPassword, char[] newPassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        Enumeration<String> aliases = keystore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keystore.isKeyEntry(alias)) continue;
            KeyStore.PasswordProtection oldPP = new KeyStore.PasswordProtection(oldPassword);
            KeyStore.Entry entry = keystore.getEntry(alias, oldPP);
            KeyStore.PasswordProtection newPP = new KeyStore.PasswordProtection(newPassword);
            keystore.setEntry(alias, entry, newPP);
        }
    }
}

