/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.publisher.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ServiceContainer {
    private final Set<ServiceHolder> services;
    private final BundleContext bundleContext;

    ServiceContainer(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.services = new HashSet<ServiceHolder>();
    }

    ServiceHolder add(ServiceReference reference) {
        return this.add(this.bundleContext.getService(reference), reference);
    }

    void remove(Object service) {
        this.services.remove(this.find(service));
    }

    ServiceHolder[] getServices() {
        HashSet<ServiceHolder> result = new HashSet<ServiceHolder>();
        Iterator<ServiceHolder> iterator = this.services.iterator();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return result.toArray(new ServiceHolder[result.size()]);
    }

    ServiceHolder find(Object service) {
        Finder finder = new Finder();
        return finder.findServiceHolder(service, this.services);
    }

    void clear() {
        this.services.clear();
    }

    int size() {
        return this.services.size();
    }

    private ServiceHolder add(Object service, ServiceReference reference) {
        ServiceHolder result = this.find(service);
        if (this.notFound(result)) {
            result = new ServiceHolder(service, reference);
            this.services.add(result);
        } else if (this.referenceIsMissing(reference, result)) {
            result.setServiceReference(reference);
        }
        return result;
    }

    private boolean notFound(ServiceHolder result) {
        return result == null;
    }

    private boolean referenceIsMissing(ServiceReference reference, ServiceHolder result) {
        return reference != null && result.getReference() == null;
    }

    static class Finder {
        Finder() {
        }

        ServiceHolder findServiceHolder(Object service, Set<ServiceHolder> collection) {
            Iterator<ServiceHolder> iterator = collection.iterator();
            ServiceHolder result = null;
            while (iterator.hasNext()) {
                ServiceHolder serviceHolder = iterator.next();
                Object found = serviceHolder.getService();
                if (!service.equals(found)) continue;
                result = serviceHolder;
            }
            return result;
        }
    }

    static class ServiceHolder {
        private ServiceReference serviceReference;
        private final Object service;

        ServiceHolder(Object service, ServiceReference serviceReference) {
            this.service = service;
            this.serviceReference = serviceReference;
        }

        Object getService() {
            return this.service;
        }

        ServiceReference getReference() {
            return this.serviceReference;
        }

        void setServiceReference(ServiceReference serviceReference) {
            this.serviceReference = serviceReference;
        }
    }
}

