/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.entities;

import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.junit.jupiter.api.Test;

public class EntitiesHoverExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void local() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE root [\r\n  <!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root>\r\n  &mdas|h;\r\n</root>";
        XMLAssert.assertHover(xml, "src/test/resources/test.xml", "**Entity mdash**" + System.lineSeparator() + " * Value: `&#x2014;`" + System.lineSeparator() + " * Type: `Local`" + System.lineSeparator() + " * Source: [test.xml](src/test/resources/test.xml)", XMLAssert.r(5, 2, 5, 9));
    }

    @Test
    public void localWithSYSTEM() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" standalone=\"no\" ?>\r\n\t<!DOCTYPE copyright [\r\n\t  <!ELEMENT copyright (#PCDATA)>\r\n\t  <!ENTITY c SYSTEM \"http://www.xmlwriter.net/copyright.xml\">\r\n\t]>\r\n\t<copyright>&|c;</copyright>";
        XMLAssert.assertHover(xml, "src/test/resources/test.xml", "**Entity c**" + System.lineSeparator() + " * Type: `Local`" + System.lineSeparator() + " * System ID: `http://www.xmlwriter.net/copyright.xml`" + System.lineSeparator() + " * Source: [test.xml](src/test/resources/test.xml)", XMLAssert.r(5, 12, 5, 15));
    }

    @Test
    public void external() throws Exception {
        String baseDTDURI = EntitiesHoverExtensionsTest.getDTDFileURI("base.dtd");
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n<!DOCTYPE root-element SYSTEM \"dtd/entities/base.dtd\" [\r\n<!ENTITY mdash \"&#x2014;\">\r\n]>\r\n<root-element>\r\n\r\n &f|oo;</root-element>";
        XMLAssert.assertHover(xml, "src/test/resources/test.xml", "**Entity foo**" + System.lineSeparator() + " * Value: `bar`" + System.lineSeparator() + " * Type: `External`" + System.lineSeparator() + " * Source: [base.dtd](" + baseDTDURI + ")", XMLAssert.r(6, 1, 6, 6));
    }

    @Test
    public void externalWithSYSTEM() throws Exception {
        String baseDTDURI = EntitiesHoverExtensionsTest.getDTDFileURI("base-system.dtd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE author SYSTEM \"dtd/entities/base-system.dtd\">\r\n<author>&wr|iter;&copyright;</author>";
        XMLAssert.assertHover(xml, "src/test/resources/test.xml", "**Entity writer**" + System.lineSeparator() + " * Type: `External`" + System.lineSeparator() + " * Public ID: `public id`" + System.lineSeparator() + " * System ID: `entity uri`" + System.lineSeparator() + " * Source: [base-system.dtd](" + baseDTDURI + ")", XMLAssert.r(2, 8, 2, 16));
        xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE author SYSTEM \"dtd/entities/base-system.dtd\">\r\n<author>&writer;&cop|yright;</author>";
        XMLAssert.assertHover(xml, "src/test/resources/test.xml", "**Entity copyright**" + System.lineSeparator() + " * Type: `External`" + System.lineSeparator() + " * System ID: `uri`" + System.lineSeparator() + " * Source: [base-system.dtd](" + baseDTDURI + ")", XMLAssert.r(2, 16, 2, 27));
    }

    @Test
    public void predefined() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<root>\r\n  &am|p;\r\n</root>";
        XMLAssert.assertHover(xml, "**Entity amp**" + System.lineSeparator() + " * Value: `&#38;`" + System.lineSeparator() + " * Type: `Predefined`", XMLAssert.r(2, 2, 2, 7));
    }

    private static String getDTDFileURI(String dtdURI) throws URI.MalformedURIException {
        return XMLEntityManager.expandSystemId((String)("dtd/entities/" + dtdURI), (String)"src/test/resources/test.xml", (boolean)true);
    }
}

