/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintLabelPart;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileDefinition;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCompletionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDefinitionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaHoverParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaInlayHintParams;
import org.eclipse.lsp4mp.commons.codeaction.CodeActionData;
import org.eclipse.lsp4mp.commons.codeaction.ICodeActionId;
import org.eclipse.lsp4mp.commons.codeaction.MicroProfileCodeActionId;
import org.eclipse.lsp4mp.jdt.core.PropertiesManagerForJava;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaErrorCode;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTMicroProfileUtils;
import org.junit.Assert;

public class MicroProfileForJavaAssert {
    public static MicroProfileJavaCodeActionParams createCodeActionParams(String uri, Diagnostic d) {
        return MicroProfileForJavaAssert.createCodeActionParams(uri, d, true);
    }

    public static MicroProfileJavaCodeActionParams createCodeActionParams(String uri, Diagnostic d, boolean commandSupported) {
        TextDocumentIdentifier textDocument = new TextDocumentIdentifier(uri);
        Range range = d.getRange();
        CodeActionContext context = new CodeActionContext();
        context.setDiagnostics(Arrays.asList(d));
        MicroProfileJavaCodeActionParams codeActionParams = new MicroProfileJavaCodeActionParams(textDocument, range, context);
        codeActionParams.setResourceOperationSupported(true);
        codeActionParams.setCommandConfigurationUpdateSupported(commandSupported);
        codeActionParams.setResolveSupported(false);
        return codeActionParams;
    }

    public static void assertJavaCodeAction(MicroProfileJavaCodeActionParams params, IJDTUtils utils, CodeAction ... expected) throws JavaModelException {
        List actual = PropertiesManagerForJava.getInstance().codeAction(params, utils, (IProgressMonitor)new NullProgressMonitor());
        MicroProfileForJavaAssert.assertCodeActions(actual != null && actual.size() > 0 ? actual : Collections.emptyList(), expected);
    }

    public static void assertCodeActions(List<? extends CodeAction> actual, CodeAction ... expected) {
        actual.stream().forEach(ca -> {
            ca.setCommand(null);
            ca.setKind(null);
            if (ca.getEdit() != null && ca.getEdit().getChanges() != null) {
                Assert.assertTrue((boolean)ca.getEdit().getChanges().isEmpty());
                ca.getEdit().setChanges(null);
            }
            if (ca.getDiagnostics() != null) {
                ca.getDiagnostics().forEach(d -> {
                    d.setSeverity(null);
                    d.setMessage("");
                    d.setSource(null);
                });
            }
        });
        Assert.assertEquals((long)expected.length, (long)actual.size());
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((String)("Assert title [" + i + "]"), (Object)expected[i].getTitle(), (Object)actual.get(i).getTitle());
            Assert.assertEquals((String)("Assert edit [" + i + "]"), (Object)expected[i].getEdit(), (Object)actual.get(i).getEdit());
            Assert.assertEquals((String)("Assert id [" + i + "]"), (Object)((CodeActionData)expected[i].getData()).getCodeActionId(), (Object)((CodeActionData)actual.get(i).getData()).getCodeActionId());
            ++i;
        }
    }

    public static CodeAction ca(String uri, String title, MicroProfileCodeActionId id, Diagnostic d, TextEdit ... te) {
        CodeAction codeAction = new CodeAction();
        codeAction.setTitle(title);
        codeAction.setDiagnostics(Arrays.asList(d));
        VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier(uri, Integer.valueOf(0));
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(versionedTextDocumentIdentifier, Arrays.asList(te));
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(Arrays.asList(Either.forLeft((Object)textDocumentEdit)));
        codeAction.setEdit(workspaceEdit);
        codeAction.setData((Object)new CodeActionData((ICodeActionId)id));
        return codeAction;
    }

    public static TextEdit te(int startLine, int startCharacter, int endLine, int endCharacter, String newText) {
        TextEdit textEdit = new TextEdit();
        textEdit.setNewText(newText);
        textEdit.setRange(MicroProfileForJavaAssert.r(startLine, startCharacter, endLine, endCharacter));
        return textEdit;
    }

    public static void assertJavaCompletion(MicroProfileJavaCompletionParams params, IJDTUtils utils, CompletionItem ... expected) throws JavaModelException {
        CompletionList actual = PropertiesManagerForJava.getInstance().completion(params, utils, (IProgressMonitor)new NullProgressMonitor());
        MicroProfileForJavaAssert.assertCompletion(actual != null && actual.getItems() != null && actual.getItems().size() > 0 ? actual.getItems() : Collections.emptyList(), expected);
    }

    public static void assertCompletion(List<? extends CompletionItem> actual, CompletionItem ... expected) {
        actual.stream().forEach(completionItem -> {
            completionItem.setDetail(null);
            completionItem.setFilterText(null);
            completionItem.setDocumentation(null);
        });
        Assert.assertEquals((long)expected.length, (long)actual.size());
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((String)("Assert TextEdit [" + i + "]"), (Object)expected[i].getTextEdit(), (Object)actual.get(i).getTextEdit());
            Assert.assertEquals((String)("Assert label [" + i + "]"), (Object)expected[i].getLabel(), (Object)actual.get(i).getLabel());
            Assert.assertEquals((String)("Assert Kind [" + i + "]"), (Object)expected[i].getKind(), (Object)actual.get(i).getKind());
            ++i;
        }
    }

    public static CompletionItem c(TextEdit textEdit, String label, CompletionItemKind kind) {
        CompletionItem completionItem = new CompletionItem();
        completionItem.setTextEdit(Either.forLeft((Object)textEdit));
        completionItem.setKind(kind);
        completionItem.setLabel(label);
        return completionItem;
    }

    public static Diagnostic d(int line, int startCharacter, int endCharacter, String message, DiagnosticSeverity severity, String source, IJavaErrorCode code) {
        return MicroProfileForJavaAssert.d(line, startCharacter, line, endCharacter, message, severity, source, code);
    }

    public static Diagnostic d(int startLine, int startCharacter, int endLine, int endCharacter, String message, DiagnosticSeverity severity, String source, IJavaErrorCode code) {
        return new Diagnostic(MicroProfileForJavaAssert.r(startLine, startCharacter, endLine, endCharacter), message, severity, source, code != null ? code.getCode() : null);
    }

    public static Range r(int line, int startCharacter, int endCharacter) {
        return MicroProfileForJavaAssert.r(line, startCharacter, line, endCharacter);
    }

    public static Range r(int startLine, int startCharacter, int endLine, int endCharacter) {
        return new Range(MicroProfileForJavaAssert.p(startLine, startCharacter), MicroProfileForJavaAssert.p(endLine, endCharacter));
    }

    public static Position p(int line, int character) {
        return new Position(line, character);
    }

    public static void assertJavaDiagnostics(MicroProfileJavaDiagnosticsParams params, IJDTUtils utils, Diagnostic ... expected) throws JavaModelException {
        List actual = PropertiesManagerForJava.getInstance().diagnostics(params, utils, (IProgressMonitor)new NullProgressMonitor());
        MicroProfileForJavaAssert.assertDiagnostics(actual != null && actual.size() > 0 ? ((PublishDiagnosticsParams)actual.get(0)).getDiagnostics() : Collections.emptyList(), expected);
    }

    public static void assertDiagnostics(List<Diagnostic> actual, Diagnostic ... expected) {
        MicroProfileForJavaAssert.assertDiagnostics(actual, Arrays.asList(expected), false);
    }

    public static void assertDiagnostics(List<Diagnostic> actual, List<Diagnostic> expected, boolean filter) {
        List<Object> received = actual;
        boolean filterMessage = expected != null && !expected.isEmpty() && (expected.get(0).getMessage() == null || expected.get(0).getMessage().isEmpty());
        if (filter) {
            received = actual.stream().map(d -> {
                Diagnostic simpler = new Diagnostic(d.getRange(), "");
                simpler.setCode(d.getCode());
                if (filterMessage) {
                    simpler.setMessage(d.getMessage());
                }
                return simpler;
            }).collect(Collectors.toList());
        }
        Assert.assertArrayEquals((String)"Unexpected diagnostics:", (Object[])expected.toArray(), (Object[])received.toArray());
    }

    public static void assertJavaHover(Position hoverPosition, String javaFileUri, IJDTUtils utils, Hover expected) throws JavaModelException {
        MicroProfileJavaHoverParams params = new MicroProfileJavaHoverParams();
        params.setDocumentFormat(DocumentFormat.Markdown);
        params.setPosition(hoverPosition);
        params.setUri(javaFileUri);
        params.setSurroundEqualsWithSpaces(true);
        MicroProfileForJavaAssert.assertJavaHover(params, utils, expected);
    }

    public static void assertJavaHover(MicroProfileJavaHoverParams params, IJDTUtils utils, Hover expected) throws JavaModelException {
        Hover actual = PropertiesManagerForJava.getInstance().hover(params, utils, (IProgressMonitor)new NullProgressMonitor());
        MicroProfileForJavaAssert.assertHover(expected, actual);
    }

    public static void assertHover(Hover expected, Hover actual) {
        if (expected == null || actual == null) {
            Assert.assertEquals((Object)expected, (Object)actual);
        } else {
            Assert.assertEquals((Object)expected.getContents().getRight(), (Object)actual.getContents().getRight());
            Assert.assertEquals((Object)expected.getRange(), (Object)actual.getRange());
        }
    }

    public static Hover h(String hoverContent, int startLine, int startCharacter, int endLine, int endCharacter) {
        Range range = MicroProfileForJavaAssert.r(startLine, startCharacter, endLine, endCharacter);
        Hover hover = new Hover();
        hover.setContents(Either.forRight((Object)new MarkupContent("markdown", hoverContent)));
        hover.setRange(range);
        return hover;
    }

    public static Hover h(String hoverContent, int line, int startCharacter, int endCharacter) {
        return MicroProfileForJavaAssert.h(hoverContent, line, startCharacter, line, endCharacter);
    }

    public static void assertJavaDefinitions(Position position, String javaFileUri, IJDTUtils utils, MicroProfileDefinition ... expected) throws JavaModelException {
        MicroProfileJavaDefinitionParams params = new MicroProfileJavaDefinitionParams();
        params.setPosition(position);
        params.setUri(javaFileUri);
        List actual = PropertiesManagerForJava.getInstance().definition(params, utils, (IProgressMonitor)new NullProgressMonitor());
        MicroProfileForJavaAssert.assertDefinitions(actual, expected);
    }

    public static void assertDefinitions(List<MicroProfileDefinition> actual, MicroProfileDefinition ... expected) {
        Assert.assertEquals((long)expected.length, (long)actual.size());
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((String)("Assert selectPropertyName [" + i + "]"), (Object)expected[i].getSelectPropertyName(), (Object)actual.get(i).getSelectPropertyName());
            Assert.assertEquals((String)("Assert location [" + i + "]"), (Object)expected[i].getLocation(), (Object)actual.get(i).getLocation());
            ++i;
        }
    }

    public static MicroProfileDefinition def(Range originSelectionRange, String targetUri, Range targetRange) {
        return MicroProfileForJavaAssert.def(originSelectionRange, targetUri, targetRange, null);
    }

    public static MicroProfileDefinition def(Range originSelectionRange, String targetUri, String selectPropertyName) {
        return MicroProfileForJavaAssert.def(originSelectionRange, targetUri, null, selectPropertyName);
    }

    private static MicroProfileDefinition def(Range originSelectionRange, String targetUri, Range targetRange, String selectPropertyName) {
        MicroProfileDefinition definition = new MicroProfileDefinition();
        LocationLink location = new LocationLink();
        location.setOriginSelectionRange(originSelectionRange);
        location.setTargetUri(targetUri);
        if (targetRange != null) {
            location.setTargetRange(targetRange);
            location.setTargetSelectionRange(targetRange);
        }
        definition.setLocation(location);
        definition.setSelectPropertyName(selectPropertyName);
        return definition;
    }

    public static String fixURI(URI uri) {
        String uriString = uri.toString();
        return uriString.replaceFirst("file:/([^/])", "file:///$1");
    }

    public static SymbolInformation si(String name, Range range) {
        SymbolInformation symbolInformation = new SymbolInformation();
        symbolInformation.setName(name);
        Location location = new Location("", range);
        symbolInformation.setLocation(location);
        return symbolInformation;
    }

    public static void assertWorkspaceSymbols(IJavaProject javaProject, IJDTUtils utils, SymbolInformation ... expected) throws JavaModelException {
        List actual = PropertiesManagerForJava.getInstance().workspaceSymbols(JDTMicroProfileUtils.getProjectURI((IJavaProject)javaProject), utils, (IProgressMonitor)new NullProgressMonitor());
        MicroProfileForJavaAssert.assertWorkspaceSymbols(Arrays.asList(expected), actual);
    }

    public static void assertWorkspaceSymbols(List<SymbolInformation> expected, List<SymbolInformation> actual) {
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Collections.sort(expected, (si1, si2) -> si1.getName().compareTo(si2.getName()));
        Collections.sort(actual, (si1, si2) -> si1.getName().compareTo(si2.getName()));
        int i = 0;
        while (i < expected.size()) {
            MicroProfileForJavaAssert.assertSymbolInformation(expected.get(i), actual.get(i));
            ++i;
        }
    }

    public static void assertSymbolInformation(SymbolInformation expected, SymbolInformation actual) {
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getLocation().getRange(), (Object)actual.getLocation().getRange());
    }

    public static void assertCodeLens(MicroProfileJavaCodeLensParams params, IJDTUtils utils, CodeLens ... expected) throws JavaModelException {
        List actual = PropertiesManagerForJava.getInstance().codeLens(params, utils, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((long)expected.length, (long)actual.size());
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((Object)expected[i], actual.get(i));
            ++i;
        }
    }

    public static CodeLens cl(String title, String commandId, Range range) {
        CodeLens codeLens = new CodeLens(range);
        codeLens.setCommand(new Command(title, commandId, Collections.singletonList(title)));
        return codeLens;
    }

    public static void assertInlayHints(MicroProfileJavaInlayHintParams params, IJDTUtils utils, InlayHint ... expected) throws JavaModelException {
        List actual = PropertiesManagerForJava.getInstance().inlayHint(params, utils, (IProgressMonitor)new NullProgressMonitor());
        MicroProfileForJavaAssert.assertInlayHint(actual, expected);
    }

    public static InlayHint ih(Position position, String label) {
        return new InlayHint(position, Either.forLeft((Object)label));
    }

    public static InlayHint ih(Position position, InlayHintLabelPart ... parts) {
        return new InlayHint(position, Either.forRight(Arrays.asList(parts)));
    }

    public static InlayHintLabelPart ihLabel(String label) {
        return new InlayHintLabelPart(label);
    }

    public static InlayHintLabelPart ihLabel(String label, String tooltip, Command command) {
        InlayHintLabelPart part = MicroProfileForJavaAssert.ihLabel(label);
        part.setCommand(command);
        part.setTooltip(tooltip);
        return part;
    }

    public static void assertInlayHint(List<InlayHint> actual, InlayHint ... expected) {
        Assert.assertEquals((long)expected.length, (long)actual.size());
        int i = 0;
        while (i < expected.length) {
            Assert.assertEquals((String)("position at " + i), (Object)expected[i].getPosition(), (Object)actual.get(i).getPosition());
            Assert.assertEquals((String)("label at " + i), (Object)expected[i].getLabel(), (Object)actual.get(i).getLabel());
            ++i;
        }
    }
}

