/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.all.tests;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.m2m.atl.common.ATL.ATLPackage;
import org.eclipse.ocl.examples.xtext.tests.NoHttpURIHandlerImpl;
import org.eclipse.ocl.examples.xtext.tests.TestFile;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.internal.resource.StandaloneProjectMap;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.pivot.qvtrelation.QVTrelationPackage;
import org.eclipse.qvtd.xml.utilities.XMLmodelResourceFactoryImpl;
import org.eclipse.qvtd.xml.utilities.XMLmodelResourceImpl;
import org.eclipse.qvtd.xtext.qvtbase.tests.XtextTestCase;

public class XMLmodelTests
extends XtextTestCase {
    public static @NonNull TestFile copyFile(@NonNull TestProject testProject, @NonNull URIConverter uriConverter, @NonNull URI sourceURI) throws IOException {
        InputStream inputStream = uriConverter.createInputStream(sourceURI);
        String lastSegment = sourceURI.lastSegment();
        assert (lastSegment != null);
        return testProject.getOutputFile(lastSegment, inputStream);
    }

    protected @NonNull Resource doXMLtest(URI inURI, boolean doCompare, boolean ignoreEcore) throws Exception {
        String testExtension = inURI.fileExtension();
        String testFileName = inURI.trimFileExtension().lastSegment();
        ProjectManager projectManager = this.getTestProjectManager();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        projectManager.initializeResourceSet((ResourceSet)resourceSet);
        TestProject testProject = this.getTestProject();
        TestFile outFile = testProject.getOutputFile(String.valueOf(testFileName) + ".out." + testExtension);
        TestFile xmlFile = testProject.getOutputFile(String.valueOf(testFileName) + ".xml");
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(testExtension, new XMLmodelResourceFactoryImpl());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        Resource xmlResource = resourceSet.createResource(inURI, "");
        HashMap<String, Boolean> loadOptions = new HashMap<String, Boolean>();
        if (ignoreEcore) {
            loadOptions.put("ignore-ecore", Boolean.TRUE);
        }
        xmlResource.load(loadOptions);
        xmlResource.toString();
        URI xmlURI = xmlFile.getURI();
        URI outURI = outFile.getURI();
        xmlResource.setURI(outURI);
        xmlResource.save(XMIUtil.createSaveOptions());
        Resource xmlResource2 = resourceSet.createResource(xmlURI);
        xmlResource2.getContents().addAll((Collection)xmlResource.getContents());
        xmlResource2.save(XMIUtil.createSaveOptions());
        if (doCompare) {
            ResourceSetImpl resourceSet2 = new ResourceSetImpl();
            NoHttpURIHandlerImpl.install((ResourceSet)resourceSet2);
            projectManager.initializeResourceSet((ResourceSet)resourceSet2);
            projectManager.configure((ResourceSet)resourceSet2, StandaloneProjectMap.LoadFirstStrategy.INSTANCE, StandaloneProjectMap.MapToFirstConflictHandler.INSTANCE);
            resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
            resourceSet2.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMLResourceFactoryImpl());
            Resource resource1 = resourceSet2.getResource(inURI, true);
            Resource resource2 = resourceSet2.getResource(outURI, true);
            assert (resource1 != null && resource2 != null);
            URI uri = URI.createURI((String)"assertSameModel");
            resource1.setURI(uri);
            resource2.setURI(uri);
            TestUtil.assertSameModel((Resource)resource1, (Resource)resource2);
            resource1.setURI(inURI);
            resource2.setURI(outURI);
        }
        xmlResource.getContents().addAll((Collection)xmlResource2.getContents());
        return xmlResource;
    }

    public static void assertSameModel(@NonNull Resource expectedResource, @NonNull Resource actualResource) throws IOException, InterruptedException {
        TestUtil.assertSameModel((Resource)expectedResource, (Resource)actualResource);
    }

    public void testXML_junit_noframes_xsl() throws Exception {
        String inPath = String.valueOf(this.getTestBundleName()) + "/models/junit-noframes.xsl";
        URI inURI = URI.createPlatformResourceURI((String)inPath, (boolean)true);
        this.doXMLtest(inURI, false, true);
    }

    public void testXML_Ecore_ecore() throws Exception {
        String inPath = "org.eclipse.emf.ecore/model/Ecore.ecore";
        URI inURI = URI.createPlatformResourceURI((String)inPath, (boolean)true);
        XMLmodelResourceImpl resource = (XMLmodelResourceImpl)this.doXMLtest(inURI, true, false);
        XMLmodelTests.assertNoValidationErrors((String)("Loading '" + resource.getURI().toString() + "'"), (Resource)resource);
    }

    public void testXML_Families2Persons_qvtras_xmi() throws Exception {
        OCL ocl = OCL.newInstance((ProjectManager)OCL.CLASS_PATH);
        URIConverter uriConverter = ocl.getResourceSet().getURIConverter();
        TestProject testProject = this.getTestProject();
        TestFile inFile = XMLmodelTests.copyFile(testProject, uriConverter, this.getModelsURI("Families2Persons.qvtras.xmi"));
        QVTrelationPackage.eINSTANCE.getClass();
        URI inURI = inFile.getURI();
        XMLmodelResourceImpl resource = (XMLmodelResourceImpl)this.doXMLtest(inURI, true, false);
        ocl.dispose();
    }

    public void testXML_Families2Persons_atl_xmi() throws Exception {
        ATLPackage.eINSTANCE.getClass();
        String inPath = String.valueOf(this.getTestBundleName()) + "/models/Families2Persons.atl.xmi";
        URI inURI = URI.createPlatformResourceURI((String)inPath, (boolean)true);
        XMLmodelResourceImpl resource = (XMLmodelResourceImpl)this.doXMLtest(inURI, true, false);
        XMLmodelTests.assertNoValidationErrors((String)("Loading '" + resource.getURI().toString() + "'"), (Resource)resource);
    }
}

