/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TraceClassRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;

public class CyclicRegionsAnalysis {
    private final @NonNull Set<@NonNull RegionAnalysis> cyclicRegionAnalyses = new HashSet<RegionAnalysis>();
    private final @NonNull Set<@NonNull TraceClassRegionAnalysis> cyclicTraceClassAnalyses = new HashSet<TraceClassRegionAnalysis>();

    public CyclicRegionsAnalysis(@NonNull Iterable<@NonNull RegionAnalysis> regionAnalyses) {
        this.analyze(regionAnalyses);
    }

    private void analyze(@NonNull Iterable<@NonNull RegionAnalysis> regionAnalyses) {
        Map<@NonNull RegionAnalysis, @NonNull Set<@NonNull RegionAnalysis>> partitioner2predecessors = CompilerUtil.computeTransitivePredecessors(regionAnalyses);
        Map<@NonNull RegionAnalysis, @NonNull Set<@NonNull RegionAnalysis>> partitioner2successors = CompilerUtil.computeTransitiveSuccessors(partitioner2predecessors);
        for (RegionAnalysis regionAnalysis : regionAnalyses) {
            HashSet<@NonNull E> intersection = new HashSet(partitioner2predecessors.get(regionAnalysis));
            intersection.retainAll((Collection)partitioner2successors.get(regionAnalysis));
            this.cyclicRegionAnalyses.addAll(intersection);
        }
        if (this.cyclicRegionAnalyses.isEmpty()) {
            return;
        }
        HashSet<@NonNull E> consumedTraceClassAnalyses = new HashSet();
        HashSet<@NonNull E> superProducedTraceClassAnalyses = new HashSet();
        for (RegionAnalysis cyclicRegionAnalysis : this.cyclicRegionAnalyses) {
            Iterable<TraceClassRegionAnalysis> superProducedTraceClassAnalyses2;
            Iterable<@NonNull TraceClassRegionAnalysis> consumedTraceClassAnalyses2 = cyclicRegionAnalysis.getConsumedTraceClassAnalyses();
            if (consumedTraceClassAnalyses2 != null) {
                Iterables.addAll(consumedTraceClassAnalyses, consumedTraceClassAnalyses2);
            }
            if ((superProducedTraceClassAnalyses2 = cyclicRegionAnalysis.getSuperProducedTraceClassAnalyses()) == null) continue;
            Iterables.addAll(superProducedTraceClassAnalyses, superProducedTraceClassAnalyses2);
        }
        this.cyclicTraceClassAnalyses.addAll(consumedTraceClassAnalyses);
        this.cyclicTraceClassAnalyses.retainAll(superProducedTraceClassAnalyses);
        if (TransformationPartitioner.CYCLES.isActive()) {
            this.showCycles(this.cyclicRegionAnalyses.iterator().next().getTransformationAnalysis(), this.cyclicRegionAnalyses);
        }
    }

    public boolean isCyclic(@NonNull RegionAnalysis regionAnalysis) {
        return this.cyclicRegionAnalyses.contains(regionAnalysis);
    }

    public boolean isCyclic(@NonNull TraceClassRegionAnalysis traceClassAnalysis) {
        assert (this.cyclicTraceClassAnalyses != null);
        return this.cyclicTraceClassAnalyses.contains(traceClassAnalysis);
    }

    protected void showCycles(@NonNull AbstractTransformationAnalysis transformationAnalysis, @NonNull Set<@NonNull RegionAnalysis> cyclicRegionAnalyses) {
        if (TransformationPartitioner.CYCLES.isActive()) {
            if (cyclicRegionAnalyses.isEmpty()) {
                TransformationPartitioner.CYCLES.println("No cycles");
            } else {
                for (RegionAnalysis cyclicRegionAnalysis : cyclicRegionAnalyses) {
                    Iterable<TraceClassRegionAnalysis> superProducedTraceClassAnalyses;
                    StringBuilder s = new StringBuilder();
                    s.append(cyclicRegionAnalysis.getName());
                    Iterable<@NonNull TraceClassRegionAnalysis> consumedTraceClassAnalyses = cyclicRegionAnalysis.getConsumedTraceClassAnalyses();
                    if (consumedTraceClassAnalyses != null) {
                        s.append("\n  ConsumedTraceClassAnalyses:");
                        for (TraceClassRegionAnalysis consumedTraceClassAnalysis : consumedTraceClassAnalyses) {
                            s.append("\n\t" + consumedTraceClassAnalysis);
                        }
                    }
                    if ((superProducedTraceClassAnalyses = cyclicRegionAnalysis.getSuperProducedTraceClassAnalyses()) != null) {
                        s.append("\n  ProducedTraceClassAnalyses:");
                        for (TraceClassRegionAnalysis producedTraceClassAnalysis : superProducedTraceClassAnalyses) {
                            s.append("\n\t" + producedTraceClassAnalysis);
                        }
                    }
                    TransformationPartitioner.CYCLES.println(s.toString());
                }
            }
        }
    }
}

