/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.AbstractHyperlink;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class QvtFileHyperlink
extends AbstractHyperlink {
    private final URI myDestinationURI;
    private final IRegion myDestinationRevealRegion;
    private final IRegion myDestinationSelectRegion;

    public QvtFileHyperlink(IRegion hyperlinkRegion, URI destinationURI, IRegion destinationRevealRegion, IRegion destinationSelectRegion) {
        super(hyperlinkRegion);
        if (destinationURI == null) {
            throw new IllegalArgumentException();
        }
        this.myDestinationURI = destinationURI;
        this.myDestinationRevealRegion = destinationRevealRegion;
        this.myDestinationSelectRegion = destinationSelectRegion;
    }

    public void open() {
        try {
            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            activePage.getNavigationHistory().markLocation(activePage.getActiveEditor());
            IFile file = URIUtils.getFile((URI)this.myDestinationURI);
            if (file == null) {
                return;
            }
            FileEditorInput fileEditorInput = new FileEditorInput(file);
            QvtEditor newEditor = (QvtEditor)activePage.openEditor((IEditorInput)fileEditorInput, "org.eclipse.m2m.qvt.oml.editor.ui.QvtEditor", true);
            ISourceViewer viewer = newEditor.getSourceViewerOpened();
            if (viewer == null || viewer.getTextWidget().isDisposed()) {
                return;
            }
            if (this.myDestinationRevealRegion != null) {
                viewer.revealRange(this.myDestinationRevealRegion.getOffset(), this.myDestinationRevealRegion.getLength());
            }
            if (this.myDestinationSelectRegion != null) {
                viewer.setSelectedRange(this.myDestinationSelectRegion.getOffset(), this.myDestinationSelectRegion.getLength());
            }
            activePage.getNavigationHistory().markLocation(activePage.getActiveEditor());
        }
        catch (PartInitException partInitException) {}
    }
}

