/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ease.lang.python.jupyter.internal;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.lang.python.py4j.internal.IPythonSideEngine;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.osgi.framework.Bundle;
import py4j.ClientServer;
import py4j.JavaServer;

public class JupyterProxy {
    private static final int PYTHON_SHUTDOWN_TIMEOUT_SECONDS = 10;
    private static final int PYTHON_STARTUP_TIMEOUT_SECONDS = 60;
    private static final String PYSRC_EASE_PY4J_MAIN_DIR = "/pysrc/";
    private static final String PY4J_PYTHON_BUNDLE_ID = "py4j-python";
    private static final String EASE_PY4J_BUNDLE_ID = "org.eclipse.ease.lang.python.py4j";
    private static final String JUPYTER_PATH = "JUPYTER_PATH";
    private static final String PYTHON_PATH = "PYTHONPATH";
    private static final String EASE_PYTHON_COMMON_BUNDLE_ID = "org.eclipse.ease.lang.python";
    private static final String PY4J_PATH = "PY4J_PATH";
    private static final String EASE_PYTHON_COMMON_SRC = "EASE_PYTHON_COMMON_SRC";
    private static final String EASE_PY4J_SRC = "EASE_PY4J_SRC";
    private static final String JUPYTER_TOKEN = "JUPYTER_TOKEN";
    private static final String EASE_JAVA_PORT = "EASE_JAVA_PORT";
    private int notebookPort = -1;
    private String notebookToken = UUID.randomUUID().toString();
    private String notebookDirectory = System.getProperty("user.home");
    private boolean startBrowser = false;
    private boolean debug = false;
    private CountDownLatch pythonStartupComplete;
    private ClientServer gatewayServer;
    private IPythonSideEngine pythonSideEngine;
    private Process jupyterProcess;
    private String notebookName;
    private String pythonInterpreter = this.getPythonInterpreterExec();
    private List<Integer> cellToRun = new ArrayList<Integer>();

    public int getNotebookPort() {
        return this.notebookPort;
    }

    public JupyterProxy setNotebookPort(int notebookPort) {
        this.notebookPort = notebookPort;
        return this;
    }

    public String getNotebookToken() {
        return this.notebookToken;
    }

    public JupyterProxy setNotebookToken(String notebookToken) {
        this.notebookToken = notebookToken;
        return this;
    }

    public String getNotebookDirectory() {
        return this.notebookDirectory;
    }

    public JupyterProxy setNotebookDirectory(String notebookDirectory) {
        this.notebookDirectory = notebookDirectory;
        return this;
    }

    public JupyterProxy setStartBrowser(boolean startBrowser) {
        this.startBrowser = startBrowser;
        return this;
    }

    public ClientServer getGatewayServer() {
        return this.gatewayServer;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public JupyterProxy setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public IPythonSideEngine getPythonSideEngine() {
        return this.pythonSideEngine;
    }

    public Process getJupyterProcess() throws MalformedURLException, IOException, URISyntaxException, CoreException, InterruptedException, ScriptEngineException {
        if (this.jupyterProcess == null) {
            this.startJupyterProcess();
        }
        return this.jupyterProcess;
    }

    public void startJupyterProcess() throws InterruptedException, ScriptEngineException, IOException, URISyntaxException {
        this.notebookPort = JupyterProxy.getFreePort(8888);
        this.gatewayServer = new ClientServer.ClientServerBuilder((Object)this).javaPort(0).pythonPort(0).build();
        this.gatewayServer.startServer(true);
        int javaListeningPort = ((JavaServer)this.gatewayServer.getJavaServer()).getListeningPort();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command().add(this.pythonInterpreter);
        pb.command().add("-m");
        pb.command().add("notebook");
        pb.command().add("--notebook-dir=" + this.notebookDirectory);
        String fullPath = String.valueOf(this.notebookDirectory) + File.separator + "static";
        fullPath = fullPath.replace("\\", "\\\\");
        pb.command().add("--NotebookApp.extra_static_paths=['" + fullPath + "']");
        if (this.notebookPort > -1) {
            pb.command().add("--port=" + this.notebookPort);
        }
        if (!this.startBrowser) {
            pb.command().add("--no-browser");
        }
        if (this.debug) {
            pb.command().add("--debug");
        }
        pb.environment().put(JUPYTER_PATH, this.appendToCurrentEnvPath(JUPYTER_PATH, this.getJupyterPathDirectory().getAbsolutePath()));
        pb.environment().put(PYTHON_PATH, this.appendToCurrentEnvPath(PYTHON_PATH, this.getJupyterKernelDirectory().getAbsolutePath()));
        pb.environment().put(EASE_JAVA_PORT, String.valueOf(javaListeningPort));
        pb.environment().put(JUPYTER_TOKEN, this.notebookToken);
        pb.environment().put(PY4J_PATH, this.getPy4jPythonSrc().getAbsolutePath());
        pb.environment().put(EASE_PYTHON_COMMON_SRC, this.getEASEPythonCommonSrc().getAbsolutePath());
        pb.environment().put(EASE_PY4J_SRC, this.getPy4jEaseMainDir().getAbsolutePath());
        this.jupyterProcess = pb.start();
        this.pythonStartupComplete = new CountDownLatch(1);
    }

    private String getPythonInterpreterExec() {
        String interpreter = Platform.getPreferencesService().getString(EASE_PY4J_BUNDLE_ID, "org.eclipse.ease.lang.python.py4j.INTERPRETER", "python", null);
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            interpreter = variableManager.performStringSubstitution(interpreter);
        }
        catch (CoreException coreException) {
            interpreter = "python";
        }
        return interpreter;
    }

    private void waitForJupyterStartup() throws InterruptedException, ScriptEngineException, IOException {
        boolean scanning = true;
        InetSocketAddress address = new InetSocketAddress("localhost", this.notebookPort);
        int attempts = 0;
        while (scanning && attempts < 200) {
            try {
                ++attempts;
                SocketChannel.open(address);
                scanning = false;
            }
            catch (IOException iOException) {
                Thread.sleep(100L);
            }
        }
        if (scanning) {
            throw new ScriptEngineException("Jupyter notebook did not start within 20 seconds");
        }
    }

    public void waitForKernelStartup() throws InterruptedException, ScriptEngineException, IOException {
        this.waitForJupyterStartup();
        this.openWebBrowser();
        if (!this.pythonStartupComplete.await(60L, TimeUnit.SECONDS)) {
            throw new ScriptEngineException("Kernel process did not start within 60 seconds");
        }
    }

    public void pythonStartupComplete(int pythonPort, IPythonSideEngine pythonSideEngine) {
        JavaServer javaServer = (JavaServer)this.gatewayServer.getJavaServer();
        javaServer.resetCallbackClient(javaServer.getCallbackClient().getAddress(), pythonPort);
        this.pythonSideEngine = pythonSideEngine;
        this.pythonStartupComplete.countDown();
    }

    public List<Integer> getCellsToRun() {
        return this.cellToRun;
    }

    public void addAutoCells(List<Integer> cellsToRun) {
        this.cellToRun.addAll(cellsToRun);
    }

    private void openWebBrowser() {
        if (PlatformUI.isWorkbenchRunning()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        TimeUnit.SECONDS.sleep(3L);
                        IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null);
                        browser.openURL(JupyterProxy.this.getNoteBookURL());
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                URI uri = this.getNoteBookURL().toURI();
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private URL getNoteBookURL() throws MalformedURLException {
        String urlString = "http://localhost:" + this.notebookPort;
        if (this.notebookName != null) {
            urlString = String.valueOf(urlString) + "/notebooks/" + this.notebookName;
        }
        urlString = String.valueOf(urlString) + "?token=" + this.notebookToken;
        return new URL(urlString);
    }

    private File getEASEPythonCommonSrc() throws IOException {
        File easePythonCommonBundleFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)EASE_PYTHON_COMMON_BUNDLE_ID));
        File easePythonCommonSrc = new File(easePythonCommonBundleFile, "/pysrc");
        if (!easePythonCommonSrc.exists() || !easePythonCommonSrc.isDirectory()) {
            throw new IOException("Failed to find EASE commong python directory, expected it here: " + easePythonCommonSrc);
        }
        return easePythonCommonSrc;
    }

    private File getPy4jPythonSrc() throws IOException {
        File py4jPythonBundleFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)PY4J_PYTHON_BUNDLE_ID));
        File py4jPythonSrc = new File(py4jPythonBundleFile, "/src");
        if (!py4jPythonSrc.exists() || !py4jPythonSrc.isDirectory()) {
            throw new IOException("Failed to find py4j python directory, expected it here: " + py4jPythonSrc);
        }
        return py4jPythonSrc;
    }

    private File getPy4jEaseMainDir() throws MalformedURLException, IOException, URISyntaxException {
        URL url = new URL("platform:/plugin/org.eclipse.ease.lang.python.py4j/pysrc/");
        URL fileURL = FileLocator.toFileURL((URL)url);
        File py4jEaseMain = new File(URIUtil.toURI((URL)fileURL).normalize());
        if (!py4jEaseMain.exists() && !py4jEaseMain.isDirectory()) {
            throw new IOException("Failed to find /pysrc/, expected it here: " + py4jEaseMain);
        }
        return py4jEaseMain;
    }

    private File getJupyterPathDirectory() throws IOException, URISyntaxException {
        URL url = new URL("platform:/plugin/org.eclipse.papyrus.ease.lang.python.jupyter/jupyter");
        URL fileURL = FileLocator.toFileURL((URL)url);
        File rootDir = new File(URIUtil.toURI((URL)fileURL).normalize());
        if (!rootDir.exists() || !rootDir.isDirectory()) {
            throw new IOException("Failed to find ease-py4j Jupyter kernel root directory, expected it here: " + rootDir);
        }
        return rootDir;
    }

    private File getJupyterKernelDirectory() throws IOException, URISyntaxException {
        File jupyterPath = this.getJupyterPathDirectory();
        File kernelDirectory = new File(jupyterPath, "/kernels/ease_py4j_kernel");
        if (!kernelDirectory.exists() || !kernelDirectory.isDirectory()) {
            throw new IOException("Failed to find ease-py4j Jupyter kernel  directory, expected it here: " + kernelDirectory);
        }
        return kernelDirectory;
    }

    private String appendToCurrentEnvPath(String variableName, String value) {
        String currentPath = System.getenv(variableName);
        currentPath = currentPath == null ? value : String.valueOf(value) + File.pathSeparator + currentPath;
        return currentPath;
    }

    /*
     * Loose catch block
     */
    public static int getFreePort(int startPort) {
        ServerSocket socket = null;
        while (true) {
            int n;
            block12: {
                socket = new ServerSocket(startPort);
                socket.setReuseAddress(true);
                n = startPort;
                if (socket == null) break block12;
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            return n;
            catch (IOException iOException) {
                try {
                    ++startPort;
                    if (socket == null) continue;
                }
                catch (Throwable throwable) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    socket.close();
                }
                catch (IOException iOException3) {}
                continue;
            }
            break;
        }
    }

    public JupyterProxy setNotebook(IFile scriptFile) {
        this.notebookDirectory = scriptFile.getParent().getLocation().toOSString();
        this.notebookName = scriptFile.getName();
        return this;
    }

    public void shutDown() {
        ProcessBuilder stopProcess = new ProcessBuilder(new String[0]).command(this.pythonInterpreter, "-m", "notebook", "stop", Integer.toString(this.notebookPort));
        try {
            Process process = stopProcess.start();
            process.waitFor(10L, TimeUnit.SECONDS);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.gatewayServer != null) {
            this.gatewayServer.shutdown();
        }
    }
}

