/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.handler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.AbstractCodeFactory;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.sign.ScriptSignatureException;
import org.eclipse.ease.sign.SignatureHelper;
import org.eclipse.ease.ui.sign.GetInfo;
import org.eclipse.ease.ui.sign.PerformSignWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class PerformSignature
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFile iFile = null;
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Object firstElement = iStructuredSelection.getFirstElement();
            if (firstElement instanceof IFile) {
                iFile = (IFile)firstElement;
            }
        } else {
            Logger.info((String)"org.eclipse.ease.ui", (String)"Editor Selection");
            IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (activeEditor != null) {
                iFile = (IFile)activeEditor.getEditorInput().getAdapter(IFile.class);
            }
        }
        if (iFile != null) {
            ScriptType scriptType = ((IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class)).getScriptType(iFile.getFullPath().toString());
            if (scriptType == null) {
                new MessageDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "Error", null, "Improper file chosen.", 1, new String[]{"DONE"}, 0).open();
                return null;
            }
            GetInfo getInfo = new GetInfo();
            WizardDialog wizardDialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)new PerformSignWizard(iFile, scriptType, getInfo));
            if (wizardDialog.open() == 0) {
                try {
                    String signatureBlock = SignatureHelper.getSignatureInFormat((ScriptType)scriptType, (String)getInfo.getSignature(), (String)getInfo.getCertificates(), (String)getInfo.getSignMessageDigestAlgo(), (String)getInfo.getSignProvider());
                    if (getInfo.getSignaturePresence()) {
                        iFile.setContents((InputStream)new ByteArrayInputStream(getInfo.getContentOnly().getBytes()), true, true, null);
                    }
                    StringBuffer signToAppend = new StringBuffer();
                    signToAppend.append(AbstractCodeFactory.LINE_DELIMITER);
                    signToAppend.append(scriptType.getCodeFactory().createCommentedString(signatureBlock, true));
                    signToAppend.append(AbstractCodeFactory.LINE_DELIMITER);
                    iFile.appendContents((InputStream)new ByteArrayInputStream(signToAppend.toString().getBytes()), false, true, null);
                }
                catch (ScriptSignatureException e) {
                    this.showError(e.getMessage(), event);
                    return null;
                }
                catch (CoreException e) {
                    Logger.error((String)"org.eclipse.ease.ui", (String)e.getMessage(), (Throwable)e);
                    this.showError(e.getMessage(), event);
                    return null;
                }
                new MessageDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "Signature Performed", null, "Sigature performed successfully. \n Do \"Perform Signature...\" again to update it.", 5, new String[]{"DONE"}, 0).open();
            }
        } else {
            Logger.error((String)"org.eclipse.ease.ui", (String)"IFile object is null");
            this.showError("Cannot get corresponding file.", event);
        }
        return null;
    }

    void showError(String msg, ExecutionEvent event) {
        new MessageDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "Error", null, msg, 1, new String[]{"DONE"}, 0).open();
    }
}

