/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.Messages;
import org.eclipse.ease.ui.help.hovers.HoverManager;
import org.eclipse.ease.ui.help.hovers.IHoverContentProvider;
import org.eclipse.ease.ui.help.hovers.ModuleHelp;
import org.eclipse.ease.ui.modules.ui.ModulesComposite;
import org.eclipse.ease.ui.modules.ui.ModulesContentProvider;
import org.eclipse.ease.ui.modules.ui.ModulesFilter;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.ease.ui.tools.TextWithImage;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class ModuleExplorerView
extends ViewPart
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String VIEW_ID = "org.eclipse.ease.ui.views.modulesExplorer";
    private static final String SEARCH_DEFAULT_TEXT = Messages.ModuleExplorerView_serachModules;
    private ModulesComposite fModulesComposite;
    private TextWithImage txtSearch;
    private UpdateTreeJob fUpdateJob = null;
    private CollapseAllHandler fCollapseAllHandler;

    public void createPartControl(Composite parent) {
        GridLayout gl_parent = new GridLayout(1, false);
        gl_parent.verticalSpacing = 3;
        gl_parent.marginWidth = 0;
        gl_parent.marginHeight = 0;
        gl_parent.horizontalSpacing = 0;
        parent.setLayout((Layout)gl_parent);
        this.txtSearch = new TextWithImage(parent, 2048);
        this.txtSearch.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtSearch.setImage(Activator.getImage("org.eclipse.ease.ui", "/icons/elcl16/filter.png", true));
        this.txtSearch.getTextElement().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (ModuleExplorerView.this.fUpdateJob == null) {
                    ModuleExplorerView.this.fUpdateJob = new UpdateTreeJob();
                }
                ModuleExplorerView.this.fUpdateJob.update(ModuleExplorerView.this.txtSearch.getText().toLowerCase());
            }
        });
        this.txtSearch.setText(SEARCH_DEFAULT_TEXT);
        this.txtSearch.getTextElement().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                if (SEARCH_DEFAULT_TEXT.equals(ModuleExplorerView.this.txtSearch.getText())) {
                    ModuleExplorerView.this.txtSearch.setText("");
                }
            }

            public void focusLost(FocusEvent e) {
                if (ModuleExplorerView.this.txtSearch.getText().isEmpty()) {
                    ModuleExplorerView.this.txtSearch.setText(SEARCH_DEFAULT_TEXT);
                }
                super.focusLost(e);
            }
        });
        this.fModulesComposite = new ModulesComposite(parent, 0, false);
        this.fModulesComposite.setLayoutData(new GridData(4, 4, false, true, 1, 1));
        this.fModulesComposite.setLayout((Layout)new FillLayout(256));
        this.fModulesComposite.addFilter(ModulesFilter.visible((ModulesContentProvider)this.fModulesComposite.getTreeViewer().getContentProvider()));
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.fModulesComposite.getTreeViewer().getTree());
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fModulesComposite.getTreeViewer());
        this.fModulesComposite.getTreeViewer().getTree().setMenu(menu);
        HoverManager hoverManager = new HoverManager(parent);
        hoverManager.addHover(this.fModulesComposite.getTreeViewer(), new IHoverContentProvider(){

            @Override
            public void populateToolbar(BrowserInformationControl control, ToolBarManager toolBarManager) {
            }

            @Override
            public String getContent(Object origin, Object detail) {
                if (detail instanceof ModulesTools.ModuleEntry) {
                    detail = ((ModulesTools.ModuleEntry)detail).getEntry();
                }
                try {
                    if (detail instanceof ModuleDefinition) {
                        URL helpLocation = ModuleHelp.getModuleHelpLocation((ModuleDefinition)detail);
                        return new ModuleHelp(helpLocation).getHoverContent();
                    }
                    if (detail instanceof Field) {
                        URL helpLocation = ModuleHelp.getModuleHelpLocation(ModulesTools.getDeclaringModule((Field)detail));
                        return new ModuleHelp(helpLocation).getConstantHelp((Field)detail).getHoverContent();
                    }
                    if (detail instanceof Method) {
                        URL helpLocation = ModuleHelp.getModuleHelpLocation(ModulesTools.getDeclaringModule((Method)detail));
                        return new ModuleHelp(helpLocation).getMethodHelp((Method)detail).getHoverContent();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.fModulesComposite.getTreeViewer());
        ((IEclipsePreferences)InstanceScope.INSTANCE.getNode("org.eclipse.ease").node("modules")).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.fCollapseAllHandler = new CollapseAllHandler((AbstractTreeViewer)this.fModulesComposite.getTreeViewer());
        handlerService.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)this.fCollapseAllHandler);
    }

    public void setFocus() {
    }

    public void dispose() {
        ((IEclipsePreferences)InstanceScope.INSTANCE.getNode("org.eclipse.ease.ui").node("modules")).removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        if (this.fCollapseAllHandler != null) {
            this.fCollapseAllHandler.dispose();
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getNode().name().equals("modules")) {
            this.fModulesComposite.refresh();
        }
    }

    public IContentProvider getContentProvider() {
        return this.fModulesComposite.getTreeViewer().getContentProvider();
    }

    private class TextViewerFilter
    extends ViewerFilter {
        private String fFilterText;

        public TextViewerFilter(String filterText) {
            this.fFilterText = filterText;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.fFilterText == null || this.fFilterText.isEmpty() || this.isVisible(element)) {
                return true;
            }
            return this.isChildVisible(element);
        }

        private boolean isChildVisible(Object element) {
            ITreeContentProvider contentProvider = (ITreeContentProvider)ModuleExplorerView.this.fModulesComposite.getTreeViewer().getContentProvider();
            Object[] objectArray = contentProvider.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (this.isVisible(child) || this.isChildVisible(child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean isVisible(Object element) {
            ILabelProvider labelProvider = (ILabelProvider)ModuleExplorerView.this.fModulesComposite.getTreeViewer().getLabelProvider();
            String label = labelProvider.getText(element);
            return label.toLowerCase().contains(this.fFilterText);
        }

        private void setFilter(String filterText) {
            this.fFilterText = filterText;
        }
    }

    private class UpdateTreeJob
    extends UIJob {
        private static final long UI_DELAY_MS = 300L;
        private String fFilterText;

        public UpdateTreeJob() {
            super(Messages.ModuleExplorerView_updateModulesExplorer);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ViewerFilter[] viewerFilterArray = ModuleExplorerView.this.fModulesComposite.getTreeViewer().getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (filter instanceof TextViewerFilter) {
                    ((TextViewerFilter)filter).setFilter(this.fFilterText);
                    ModuleExplorerView.this.fModulesComposite.getTreeViewer().refresh();
                    if (this.fFilterText != null && !this.fFilterText.isEmpty()) {
                        ModuleExplorerView.this.fModulesComposite.getTreeViewer().expandAll();
                    }
                    return Status.OK_STATUS;
                }
                ++n2;
            }
            ModuleExplorerView.this.fModulesComposite.getTreeViewer().addFilter((ViewerFilter)new TextViewerFilter(this.fFilterText));
            if (this.fFilterText != null && !this.fFilterText.isEmpty()) {
                ModuleExplorerView.this.fModulesComposite.getTreeViewer().expandAll();
            }
            return Status.OK_STATUS;
        }

        public synchronized void update(String filterText) {
            this.fFilterText = filterText;
            this.schedule(300L);
        }
    }
}

