/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Text;

public class TextSelectionProvider
implements ISelectionProvider,
SelectionListener {
    private final ListenerList fListeners = new ListenerList();
    private ITextSelection fSelection = null;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.fSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof ITextSelection) {
            this.fSelection = (ITextSelection)selection;
            if (!this.fListeners.isEmpty()) {
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.fSelection);
                Object[] objectArray = this.fListeners.getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    ((ISelectionChangedListener)listener).selectionChanged(event);
                    ++n2;
                }
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source instanceof Text) {
            this.setSelection((ISelection)new TextSelection(((Text)source).getSelectionText()));
        } else if (source instanceof StyledText) {
            this.setSelection((ISelection)new TextSelection(((StyledText)source).getSelectionText()));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private class TextSelection
    implements ITextSelection {
        private final String fText;

        public TextSelection(String text) {
            this.fText = text;
        }

        public boolean isEmpty() {
            return this.fText.isEmpty();
        }

        public int getOffset() {
            return -1;
        }

        public int getLength() {
            return this.fText.length();
        }

        public int getStartLine() {
            return -1;
        }

        public int getEndLine() {
            return -1;
        }

        public String getText() {
            return this.fText;
        }
    }
}

