/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aceeditor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.papyrus.aceeditor.AceCodeEditor;
import org.eclipse.papyrus.aceeditor.AceCodeEditorConfiguration;
import org.eclipse.papyrus.aceeditor.AceCodeEditorListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.uml.properties.widgets.BodyEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class AceBodyEditor
implements BodyEditor,
AceCodeEditorListener {
    protected AceCodeEditor editor;
    private final Set<Listener> changeListeners = new HashSet<Listener>();
    private String currentValue;
    protected ModelElement context;

    public void createWidget(Composite parent, int style) {
        this.editor = new AceCodeEditor(parent, style);
        this.editor.addCommitListener(new ICommitListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void commit(AbstractEditor absEditor) {
                Event event = new Event();
                AceBodyEditor.this.currentValue = (String)AceBodyEditor.this.editor.getValue();
                event.text = AceBodyEditor.this.currentValue;
                Set set = AceBodyEditor.this.changeListeners;
                synchronized (set) {
                    AceBodyEditor.this.changeListeners.forEach(l -> l.handleEvent(event));
                }
            }
        });
        this.editor.addAceCodeEditorListener(this);
        this.editor.layout();
    }

    public void setInput(String value) {
        this.currentValue = value;
        AbstractObservableValue obs = new AbstractObservableValue(){

            public Object getValueType() {
                return String.class;
            }

            protected Object doGetValue() {
                return AceBodyEditor.this.currentValue;
            }

            protected void doSetValue(Object value) {
                if (value instanceof String) {
                    AceBodyEditor.this.currentValue = (String)value;
                }
            }
        };
        this.editor.setModelObservable((IObservableValue)obs);
        this.editor.setValue(this.currentValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.editor.dispose();
        Set<Listener> set = this.changeListeners;
        synchronized (set) {
            this.changeListeners.clear();
        }
    }

    public void addChangeListener(Listener listener) {
        this.changeListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(Listener listener) {
        Set<Listener> set = this.changeListeners;
        synchronized (set) {
            this.changeListeners.remove(listener);
        }
    }

    public String getValue() {
        return this.currentValue;
    }

    public void setReadOnly(boolean readOnly) {
        this.editor.setReadOnly(readOnly);
    }

    public void setContext(ModelElement context) {
        this.context = context;
    }

    public AceCodeEditorConfiguration getEditorConfiguration() {
        return this.editor.getConfiguration();
    }

    public void refreshEditor() {
        this.editor.refresh();
    }

    @Override
    public void onChange(String newValue) {
    }
}

