/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEditor;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EditClasspathEntryAction
extends RuntimeClasspathAction {
    private ILaunchConfiguration fConfiguration;

    public EditClasspathEntryAction(IClasspathViewer viewer, ILaunchConfiguration configuration) {
        super(ActionMessages.EditClasspathEntryAction_0, viewer);
        this.fConfiguration = configuration;
    }

    public void run() {
        IRuntimeClasspathEntry[] replacements;
        List<IRuntimeClasspathEntry> targets = this.getOrderedSelection();
        if (targets.size() != 1) {
            return;
        }
        IRuntimeClasspathEntry entry = targets.get(0);
        IRuntimeClasspathEntry[] original = new IRuntimeClasspathEntry[]{entry};
        IRuntimeClasspathEntry[] delegtes = new IRuntimeClasspathEntry[original.length];
        IClasspathEntry[] parents = new IClasspathEntry[original.length];
        int i = 0;
        while (i < delegtes.length) {
            ClasspathEntry classpathEntry = (ClasspathEntry)original[i];
            delegtes[i] = classpathEntry.getDelegate();
            parents[i] = classpathEntry.getParent();
            ++i;
        }
        IClasspathEditor editor = this.getEditor(entry);
        if (editor != null && (replacements = editor.edit(this.getShell(), this.fConfiguration, delegtes)) != null) {
            IRuntimeClasspathEntry[] wrappers = new IRuntimeClasspathEntry[replacements.length];
            List<IRuntimeClasspathEntry> list = this.getEntriesAsList();
            int index = 0;
            int i2 = 0;
            while (i2 < list.size() && index < original.length && index < replacements.length) {
                IRuntimeClasspathEntry element = list.get(i2);
                if (element == original[index]) {
                    wrappers[index] = new ClasspathEntry(replacements[index], parents[index]);
                    list.set(i2, wrappers[index]);
                    ++index;
                }
                ++i2;
            }
            this.setEntries(list);
            i2 = 0;
            while (i2 < wrappers.length) {
                this.getViewer().refresh(wrappers[i2]);
                ++i2;
            }
        }
    }

    @Override
    protected boolean updateSelection(IStructuredSelection selection) {
        IRuntimeClasspathEntry entry;
        IClasspathEditor editor;
        Object element;
        if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof IRuntimeClasspathEntry && (editor = this.getEditor(entry = (IRuntimeClasspathEntry)element)) != null) {
            return editor.canEdit(this.fConfiguration, new IRuntimeClasspathEntry[]{((ClasspathEntry)entry).getDelegate()});
        }
        return false;
    }

    protected IClasspathEditor getEditor(IRuntimeClasspathEntry entry) {
        if (entry instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)entry;
            return (IClasspathEditor)adaptable.getAdapter(IClasspathEditor.class);
        }
        return null;
    }
}

