/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.internal.ui.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateRelationshipCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.uml.service.types.internal.ui.dialogs.CollaborationRoleTreeContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;

public class RoleBindingHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterCreateRelationshipCommand(CreateRelationshipRequest request) {
        EObject reqSource = request.getSource();
        if (reqSource instanceof CollaborationUse) {
            final CollaborationUse source = (CollaborationUse)reqSource;
            final Dependency dependency = (Dependency)request.getNewElement();
            final NamedElement target = (NamedElement)request.getTarget();
            if (target == null) {
                return UnexecutableCommand.INSTANCE;
            }
            return new CreateRelationshipCommand(request){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    if (!this.canExecute()) {
                        throw new ExecutionException("Invalid arguments in create link command");
                    }
                    ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                    Shell currentShell = new Shell(Display.getCurrent(), 67680);
                    ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(currentShell, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory), (ITreeContentProvider)new CollaborationRoleTreeContentProvider());
                    try {
                        dialog.setTitle("Collaboration role binding");
                        dialog.setMessage("Select the role to bind:");
                        dialog.setAllowMultiple(false);
                        dialog.setHelpAvailable(false);
                        dialog.setInput((Object)source);
                        dialog.open();
                    }
                    finally {
                        adapterFactory.dispose();
                    }
                    if (dialog.getReturnCode() == 0) {
                        ConnectableElement roleToBind = (ConnectableElement)dialog.getFirstResult();
                        dependency.setName("binding_" + roleToBind.getName() + "_" + target.getName());
                        source.getRoleBindings().add((Object)dependency);
                        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)dependency);
                        return CommandResult.newOKCommandResult((Object)dependency);
                    }
                    return CommandResult.newCancelledCommandResult();
                }
            };
        }
        return null;
    }
}

