/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import ca.odell.glazedlists.EventList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManagerForEventList;

public abstract class AbstractAxisManagerForEventList
extends AbstractAxisManager
implements IAxisManagerForEventList {
    protected EventList<Object> eventList;
    protected static final String EXCEPTION_MESSAGE = "This method cant be call for IAxisManagerForEventList";

    @Override
    public final void setEventList(EventList<Object> list) {
        this.eventList = list;
    }

    @Override
    public void manageEvent(Notification notification) {
        if (this.ignoreEvent(notification)) {
            return;
        }
        int eventType = notification.getEventType();
        switch (eventType) {
            case 1: {
                this.manageSetNotification(notification);
                break;
            }
            case 2: {
                this.manageUnsetNotification(notification);
                break;
            }
            case 3: {
                this.manageAddNotification(notification);
                break;
            }
            case 5: {
                this.manageAddManyNotification(notification);
                break;
            }
            case 7: {
                this.manageMoveNotification(notification);
                break;
            }
            case 4: {
                this.manageRemoveNotification(notification);
                break;
            }
            case 6: {
                this.manageRemoveManyNotification(notification);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected boolean ignoreEvent(Notification notification) {
        return notification.isTouch();
    }

    protected abstract void manageRemoveManyNotification(Notification var1);

    protected abstract void manageRemoveNotification(Notification var1);

    protected abstract void manageMoveNotification(Notification var1);

    protected abstract void manageAddManyNotification(Notification var1);

    protected abstract void manageAddNotification(Notification var1);

    protected abstract void manageSetNotification(Notification var1);

    protected abstract void manageUnsetNotification(Notification var1);

    @Override
    public boolean canEditAxisHeader() {
        return false;
    }

    @Override
    protected final List<Object> createManagedObjectList() {
        return null;
    }

    @Override
    protected void addListeners() {
    }

    @Override
    protected final void axisManagerHasChanged(Notification notification) {
        throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
    }

    @Override
    protected void initializeManagedObjectList() {
        throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.eventList = null;
    }

    @Override
    public boolean isAlreadyManaged(Object object) {
        return this.eventList.contains(object);
    }

    @Override
    public final List<Object> getAllManagedAxis() {
        throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
    }

    @Override
    protected final List<Object> getElements(List<Integer> axisPositions) {
        throw new UnsupportedOperationException(EXCEPTION_MESSAGE);
    }
}

