/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.markerlistener.providers;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerProvider;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractMarkerProvider
implements IMarkerProvider {
    public static int DELETE_PMARKER_INTERVAL = 50;
    public static int CREATE_PMARKER_INTERVAL = 20;

    public void createMarkers(Resource resource, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        List children = diagnostic.getChildren();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(children.size() / CREATE_PMARKER_INTERVAL));
        CoreException exception = null;
        int i = 0;
        for (Diagnostic next : children) {
            block4: {
                try {
                    this.doCreateMarker(resource, next);
                }
                catch (CoreException e) {
                    if (exception != null) break block4;
                    exception = e;
                }
            }
            if (i++ <= CREATE_PMARKER_INTERVAL) continue;
            i = 0;
            sub.worked(1);
            this.batchCreated(resource);
        }
        sub.done();
        if (exception != null) {
            throw exception;
        }
    }

    protected abstract void doCreateMarker(Resource var1, Diagnostic var2) throws CoreException;

    protected void batchCreated(Resource resource) {
        Display display = Display.getCurrent();
        if (display != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    @Deprecated
    public void deleteMarkers(EObject eObject, IProgressMonitor monitor) throws CoreException {
        this.deleteMarkers(eObject, monitor, null, true);
    }

    public void deleteMarkers(EObject eObject, IProgressMonitor monitor, String markerType, boolean includeSubtypes) throws CoreException {
        Resource resource = eObject.eResource();
        Collection<? extends IPapyrusMarker> markers = this.getMarkers(resource, markerType, includeSubtypes);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(markers.size() / DELETE_PMARKER_INTERVAL));
        CoreException exception = null;
        int i = 0;
        for (IPapyrusMarker iPapyrusMarker : markers) {
            block5: {
                EObject markerEObj = iPapyrusMarker.getEObject();
                if (markerEObj == null || this.isContainedBy(markerEObj, eObject)) {
                    if (monitor.isCanceled()) break;
                    try {
                        iPapyrusMarker.delete();
                    }
                    catch (CoreException e) {
                        if (exception != null) break block5;
                        exception = e;
                    }
                }
            }
            if (i++ <= DELETE_PMARKER_INTERVAL) continue;
            i = 0;
            sub.worked(1);
        }
        sub.done();
        if (exception != null) {
            throw exception;
        }
    }

    private boolean isContainedBy(EObject subEObj, EObject eObj) {
        if (eObj == subEObj) {
            return true;
        }
        if (subEObj != null) {
            return this.isContainedBy(subEObj.eContainer(), eObj);
        }
        return false;
    }
}

