/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.refactoring.descriptors;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.DescriptorMessages;
import org.eclipse.jdt.internal.core.refactoring.descriptors.JavaRefactoringDescriptorUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class MoveStaticMembersDescriptor
extends JavaRefactoringDescriptor {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private boolean fDelegate = false;
    private boolean fDeprecate = false;
    private IMember[] fMembers;
    private IType fType = null;

    public MoveStaticMembersDescriptor() {
        super("org.eclipse.jdt.ui.move.static");
    }

    public MoveStaticMembersDescriptor(String project, String description, String comment, Map<String, String> arguments, int flags) {
        super("org.eclipse.jdt.ui.move.static", project, description, comment, arguments, flags);
        this.fType = (IType)JavaRefactoringDescriptorUtil.getJavaElement(this.fArguments, "input", project);
        this.fDelegate = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, ATTRIBUTE_DELEGATE, this.fDelegate);
        this.fDeprecate = JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, ATTRIBUTE_DEPRECATE, this.fDeprecate);
        this.fMembers = (IMember[])JavaRefactoringDescriptorUtil.getJavaElementArray(this.fArguments, null, "element", 1, project, IMember.class);
    }

    @Override
    protected void populateArgumentMap() {
        super.populateArgumentMap();
        String project = this.getProject();
        JavaRefactoringDescriptorUtil.setJavaElement(this.fArguments, "input", project, (IJavaElement)this.fType);
        JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_DELEGATE, this.fDelegate);
        JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, ATTRIBUTE_DEPRECATE, this.fDeprecate);
        JavaRefactoringDescriptorUtil.setJavaElementArray(this.fArguments, null, "element", project, (IJavaElement[])this.fMembers, 1);
    }

    public void setDeprecateDelegate(boolean deprecate) {
        this.fDeprecate = deprecate;
    }

    public void setDestinationType(IType type) {
        Assert.isNotNull((Object)type);
        this.fType = type;
    }

    public void setKeepOriginal(boolean delegate) {
        this.fDelegate = delegate;
    }

    public void setMembers(IMember[] members) {
        Assert.isNotNull((Object)members);
        this.fMembers = members;
    }

    @Override
    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (this.fType == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveStaticMembersDescriptor_no_type));
        }
        if (this.fMembers == null) {
            status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveStaticMembersDescriptor_no_members));
        } else {
            int index = 0;
            while (index < this.fMembers.length) {
                if (this.fMembers[index] == null) {
                    status.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveStaticMembersDescriptor_invalid_members));
                    break;
                }
                ++index;
            }
        }
        return status;
    }
}

