/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import org.eclipse.oomph.internal.ui.FlatButton;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ImageHoverButton
extends FlatButton {
    private Image defaultImage;
    private Image hoverImage;
    private Image disabledImage;

    public ImageHoverButton(Composite parent, int buttonStyle) {
        this(parent, buttonStyle, null, null);
    }

    public ImageHoverButton(Composite parent, int buttonStyle, Image image, Image hoverImage) {
        this(parent, buttonStyle, image, hoverImage, null);
    }

    public ImageHoverButton(Composite parent, int buttonStyle, Image image, Image hoverImage, Image disabledImage) {
        super(parent, buttonStyle);
        this.defaultImage = image;
        this.hoverImage = hoverImage;
        this.disabledImage = disabledImage;
        this.setDisabledBackgroundColor(null);
        this.updateImage();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateImage();
    }

    public void setDefaultImage(Image defaultImage) {
        if (this.defaultImage != defaultImage) {
            this.defaultImage = defaultImage;
            this.updateImage();
        }
    }

    public Image getDefaultImage() {
        return this.defaultImage;
    }

    public void setHoverImage(Image hoverImage) {
        if (this.hoverImage != hoverImage) {
            this.hoverImage = hoverImage;
            this.updateImage();
        }
    }

    public Image getHoverImage() {
        return this.hoverImage;
    }

    public Image getDisabledImage() {
        return this.disabledImage;
    }

    public void setDisabledImage(Image disabledImage) {
        if (this.disabledImage != disabledImage) {
            this.disabledImage = disabledImage;
            this.updateImage();
        }
    }

    @Override
    protected void onHover() {
        this.updateImage();
    }

    @Override
    protected void onFocusIn(Event event) {
        this.updateImage();
    }

    @Override
    protected void onFocusOut(Event event) {
        this.updateImage();
    }

    @Override
    protected void drawFocusState(GC gc, int x, int y, int width, int height) {
    }

    protected Image computeImage() {
        if (!this.isEnabled()) {
            return this.getDisabledImage() != null ? this.getDisabledImage() : this.getDefaultImage();
        }
        return this.isHover() || this.isFocusControl() ? this.getHoverImage() : this.getDefaultImage();
    }

    protected final void updateImage() {
        Image image = this.computeImage();
        this.setImage(image);
    }
}

