/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.util.IOUtil;

public class RemoteDataProvider
implements DataProvider {
    private final Path location;

    public RemoteDataProvider(Path location) {
        this.location = location;
    }

    @Override
    public final DataProvider.Location getLocation() {
        return DataProvider.Location.REMOTE;
    }

    public Path getStorageLocation() {
        return this.location;
    }

    public URI getURI() {
        return this.location.toUri();
    }

    @Override
    public boolean retrieve(File file) throws IOException, DataProvider.NotFoundException {
        try {
            InputStream contents = Files.newInputStream(this.location, new OpenOption[0]);
            boolean cached = contents instanceof FileInputStream;
            RemoteDataProvider.saveContents(contents, file);
            return !cached;
        }
        catch (NoSuchFileException ex) {
            throw new DataProvider.NotFoundException(file.toURI());
        }
    }

    @Override
    public void update(File file, File baseFile) throws IOException, DataProvider.NotCurrentException {
        try {
            Files.copy(file.toPath(), this.location, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Synchronization.ConflictException ex) {
            throw new DataProvider.NotCurrentException(this.getURI());
        }
    }

    @Override
    public File[] getExtraFiles() {
        return NO_FILES;
    }

    @Override
    public boolean delete() throws IOException {
        Files.delete(this.location);
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.getURI()) + "]";
    }

    public static void saveContents(InputStream contents, File file) throws IOException {
        File parentFolder = file.getParentFile();
        if (parentFolder != null) {
            parentFolder.mkdirs();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            IOUtil.copy((InputStream)contents, (OutputStream)out);
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(out);
            IOUtil.closeSilent((Closeable)contents);
            throw throwable;
        }
        IOUtil.closeSilent((Closeable)out);
        IOUtil.closeSilent((Closeable)contents);
    }
}

