/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.lang.ref.Cleaner;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public abstract class Resource {
    Device device;
    private static Consumer<Error> nonDisposedReporter;
    private ResourceTracker tracker;
    private Cleaner.Cleanable cleanable;

    static {
        boolean trackingEnabled = Boolean.getBoolean("org.eclipse.swt.graphics.Resource.reportNonDisposed");
        if (trackingEnabled) {
            Resource.setNonDisposeHandler(exception -> {
                if (exception != null) {
                    exception.printStackTrace();
                } else {
                    System.err.println("SWT Resource was not properly disposed");
                }
            });
        }
    }

    public Resource() {
        this.initNonDisposeTracking();
    }

    Resource(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.initNonDisposeTracking();
    }

    void destroy() {
    }

    void destroyHandlesExcept(Set<Integer> zoomLevels) {
    }

    public void dispose() {
        if (this.tracker != null) {
            this.tracker.reporting.set(false);
        }
        if (this.cleanable != null) {
            this.cleanable.clean();
        }
        if (this.device == null) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        this.destroy();
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public Device getDevice() {
        Device device = this.device;
        if (device == null || this.isDisposed()) {
            SWT.error(44);
        }
        return device;
    }

    void ignoreNonDisposed() {
        if (this.tracker != null) {
            this.tracker.reporting.set(false);
        }
        if (this.cleanable != null) {
            this.cleanable.clean();
        }
    }

    void init() {
        if (this.device.tracking) {
            this.device.new_Object(this);
        }
        if (this.tracker != null && this.tracker.reporting.compareAndSet(false, true)) {
            this.cleanable = ResourceTracker.cleaner.register(this, this.tracker);
        }
    }

    void initNonDisposeTracking() {
        if (this instanceof Color) {
            return;
        }
        if (nonDisposedReporter == null) {
            return;
        }
        Error error = new Error("SWT Resource was not properly disposed");
        this.tracker = new ResourceTracker(error);
    }

    public abstract boolean isDisposed();

    public static void setNonDisposeHandler(Consumer<Error> reporter) {
        nonDisposedReporter = reporter;
    }

    private static final class ResourceTracker
    implements Runnable {
        private static final Cleaner cleaner = Cleaner.create(new ResourceTrackerThreadFactory());
        private final Error allocationStack;
        private final AtomicBoolean reporting = new AtomicBoolean(false);

        ResourceTracker(Error allocationStack) {
            this.allocationStack = allocationStack;
        }

        @Override
        public void run() {
            if (!this.reporting.get()) {
                return;
            }
            if (nonDisposedReporter == null) {
                return;
            }
            nonDisposedReporter.accept(this.allocationStack);
        }
    }

    private static final class ResourceTrackerThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;

        public ResourceTrackerThreadFactory() {
            ThreadGroup root = Thread.currentThread().getThreadGroup();
            while (root.getParent() != null) {
                root = root.getParent();
            }
            this.group = new ThreadGroup(root, "SWTResourceTrackerThreadGroup");
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(this.group, r, "SWTResourceTracker", 0L, false);
            thread.setPriority(8);
            thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
            return thread;
        }
    }
}

