/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;

public abstract class ComputedList<E>
extends AbstractObservableList<E> {
    private List<E> cachedList = new ArrayList();
    private boolean dirty = true;
    private boolean stale = false;
    private IObservable[] dependencies = new IObservable[0];
    private PrivateInterface privateInterface = new PrivateInterface();
    private Object elementType;

    public static <E> IObservableList<E> create(final Supplier<List<E>> supplier) {
        Objects.requireNonNull(supplier);
        return new ComputedList<E>(){

            @Override
            protected List<E> calculate() {
                return (List)supplier.get();
            }
        };
    }

    public ComputedList() {
        this(Realm.getDefault(), null);
    }

    public ComputedList(Object elementType) {
        this(Realm.getDefault(), elementType);
    }

    public ComputedList(Realm realm) {
        this(realm, null);
    }

    public ComputedList(Realm realm, Object elementType) {
        super(realm);
        this.elementType = elementType;
    }

    @Override
    protected int doGetSize() {
        return this.doGetList().size();
    }

    @Override
    public E get(int index) {
        this.getterCalled();
        return this.doGetList().get(index);
    }

    private final List<E> getList() {
        this.getterCalled();
        return this.doGetList();
    }

    final List<E> doGetList() {
        if (this.dirty) {
            IObservable newDependency;
            IObservable[] newDependencies = ObservableTracker.runAndMonitor(this.privateInterface, this.privateInterface, null);
            this.stale = false;
            IObservable[] iObservableArray = newDependencies;
            int n = newDependencies.length;
            int n2 = 0;
            while (n2 < n) {
                newDependency = iObservableArray[n2];
                if (newDependency.isStale()) {
                    this.makeStale();
                    break;
                }
                ++n2;
            }
            if (!this.stale) {
                iObservableArray = newDependencies;
                n = newDependencies.length;
                n2 = 0;
                while (n2 < n) {
                    newDependency = iObservableArray[n2];
                    newDependency.addStaleListener(this.privateInterface);
                    ++n2;
                }
            }
            this.dependencies = newDependencies;
            this.dirty = false;
        }
        return this.cachedList;
    }

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    protected abstract List<E> calculate();

    private void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.makeStale();
            this.stopListening();
            final ArrayList<E> oldList = new ArrayList<E>(this.cachedList);
            this.fireListChange(new ListDiff<E>(){
                ListDiffEntry<E>[] differences;

                @Override
                public ListDiffEntry<E>[] getDifferences() {
                    if (this.differences == null) {
                        this.differences = Diffs.computeListDiff(oldList, ComputedList.this.getList()).getDifferences();
                    }
                    return this.differences;
                }
            });
        }
    }

    private void stopListening() {
        if (this.dependencies != null) {
            IObservable[] iObservableArray = this.dependencies;
            int n = this.dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                IObservable observable = iObservableArray[n2];
                observable.removeChangeListener(this.privateInterface);
                observable.removeStaleListener(this.privateInterface);
                ++n2;
            }
            this.dependencies = null;
        }
    }

    private void makeStale() {
        if (!this.stale) {
            this.stale = true;
            this.fireStale();
        }
    }

    @Override
    public boolean isStale() {
        this.getList();
        return this.stale;
    }

    @Override
    public Object getElementType() {
        return this.elementType;
    }

    @Override
    public synchronized void addChangeListener(IChangeListener listener) {
        super.addChangeListener(listener);
        this.computeListForListeners();
    }

    @Override
    public synchronized void addListChangeListener(IListChangeListener<? super E> listener) {
        super.addListChangeListener(listener);
        this.computeListForListeners();
    }

    private void computeListForListeners() {
        this.getRealm().exec(() -> {
            if (this.dependencies == null) {
                this.getList();
            }
        });
    }

    @Override
    public synchronized void dispose() {
        this.stopListening();
        super.dispose();
    }

    private class PrivateInterface
    implements Runnable,
    IChangeListener,
    IStaleListener {
        private PrivateInterface() {
        }

        @Override
        public void run() {
            ComputedList.this.cachedList = ComputedList.this.calculate();
            if (ComputedList.this.cachedList == null) {
                ComputedList.this.cachedList = Collections.EMPTY_LIST;
            }
        }

        @Override
        public void handleStale(StaleEvent event) {
            if (!ComputedList.this.dirty) {
                ComputedList.this.makeStale();
            }
        }

        @Override
        public void handleChange(ChangeEvent event) {
            ComputedList.this.makeDirty();
        }
    }
}

