/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.oomph.maven.provider.DependencyItemProvider;
import org.eclipse.oomph.maven.provider.ParentItemProvider;
import org.eclipse.oomph.maven.provider.ProjectItemProvider;
import org.eclipse.oomph.maven.provider.PropertyItemProvider;
import org.eclipse.oomph.maven.provider.PropertyReferenceItemProvider;
import org.eclipse.oomph.maven.provider.RealmItemProvider;
import org.eclipse.oomph.maven.util.MavenAdapterFactory;

public class MavenItemProviderAdapterFactory
extends MavenAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected RealmItemProvider realmItemProvider;
    protected ProjectItemProvider projectItemProvider;
    protected ParentItemProvider parentItemProvider;
    protected DependencyItemProvider dependencyItemProvider;
    protected PropertyItemProvider propertyItemProvider;
    protected PropertyReferenceItemProvider propertyReferenceItemProvider;

    public MavenItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
        this.supportedTypes.add(IItemStyledLabelProvider.class);
    }

    public Adapter createRealmAdapter() {
        if (this.realmItemProvider == null) {
            this.realmItemProvider = new RealmItemProvider((AdapterFactory)this);
        }
        return this.realmItemProvider;
    }

    public Adapter createProjectAdapter() {
        if (this.projectItemProvider == null) {
            this.projectItemProvider = new ProjectItemProvider((AdapterFactory)this);
        }
        return this.projectItemProvider;
    }

    public Adapter createParentAdapter() {
        if (this.parentItemProvider == null) {
            this.parentItemProvider = new ParentItemProvider((AdapterFactory)this);
        }
        return this.parentItemProvider;
    }

    public Adapter createDependencyAdapter() {
        if (this.dependencyItemProvider == null) {
            this.dependencyItemProvider = new DependencyItemProvider((AdapterFactory)this);
        }
        return this.dependencyItemProvider;
    }

    public Adapter createPropertyAdapter() {
        if (this.propertyItemProvider == null) {
            this.propertyItemProvider = new PropertyItemProvider((AdapterFactory)this);
        }
        return this.propertyItemProvider;
    }

    public Adapter createPropertyReferenceAdapter() {
        if (this.propertyReferenceItemProvider == null) {
            this.propertyReferenceItemProvider = new PropertyReferenceItemProvider((AdapterFactory)this);
        }
        return this.propertyReferenceItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.realmItemProvider != null) {
            this.realmItemProvider.dispose();
        }
        if (this.projectItemProvider != null) {
            this.projectItemProvider.dispose();
        }
        if (this.parentItemProvider != null) {
            this.parentItemProvider.dispose();
        }
        if (this.dependencyItemProvider != null) {
            this.dependencyItemProvider.dispose();
        }
        if (this.propertyItemProvider != null) {
            this.propertyItemProvider.dispose();
        }
        if (this.propertyReferenceItemProvider != null) {
            this.propertyReferenceItemProvider.dispose();
        }
    }
}

