/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions;

import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;

public final class DefaultVariable
implements IEvaluationContext {
    private final Object fDefaultVariable;
    private final IEvaluationContext fParent;
    private final IEvaluationContext fManagedPool;

    public DefaultVariable(IEvaluationContext parent, Object defaultVariable) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)defaultVariable);
        this.fParent = parent;
        while (parent instanceof DefaultVariable) {
            parent = parent.getParent();
        }
        this.fManagedPool = parent;
        this.fDefaultVariable = defaultVariable;
    }

    @Override
    public IEvaluationContext getParent() {
        return this.fParent;
    }

    @Override
    public IEvaluationContext getRoot() {
        return this.fParent.getRoot();
    }

    @Override
    public Object getDefaultVariable() {
        return this.fDefaultVariable;
    }

    @Override
    public void setAllowPluginActivation(boolean value) {
        this.fParent.setAllowPluginActivation(value);
    }

    @Override
    public boolean getAllowPluginActivation() {
        return this.fParent.getAllowPluginActivation();
    }

    @Override
    public void addVariable(String name, Object value) {
        this.fManagedPool.addVariable(name, value);
    }

    @Override
    public Object removeVariable(String name) {
        return this.fManagedPool.removeVariable(name);
    }

    @Override
    public Object getVariable(String name) {
        return this.fManagedPool.getVariable(name);
    }

    @Override
    public Object resolveVariable(String name, Object[] args) throws CoreException {
        return this.fManagedPool.resolveVariable(name, args);
    }
}

