/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.repository.helpers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.repository.Activator;
import org.eclipse.equinox.internal.p2.repository.helpers.ChecksumHelper;
import org.eclipse.equinox.internal.p2.repository.helpers.Messages;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ChecksumProducer {
    private static final int BUFFER_SIZE = 4096;
    private final String id;
    private final String algorithm;
    private final String providerName;
    private MessageDigest messageDigest;

    public ChecksumProducer(String id, String algorithm, String providerName) {
        this.id = id;
        this.algorithm = algorithm;
        this.providerName = providerName;
    }

    public MessageDigest getMessageDigest() throws GeneralSecurityException {
        if (this.messageDigest == null) {
            this.messageDigest = ChecksumProducer.getMessageDigest(this.algorithm, this.providerName);
        }
        return this.messageDigest;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getId() {
        return this.id;
    }

    @Deprecated
    public static String computeMD5(File file) throws IOException {
        try {
            return ChecksumProducer.produce(file, "MD5", null);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            return null;
        }
    }

    public static String produce(File file, String algorithm, String providerName) throws IOException, NoSuchAlgorithmException, NoSuchProviderException {
        MessageDigest messageDigest = ChecksumProducer.getMessageDigest(algorithm, providerName);
        Throwable throwable = null;
        Object var5_6 = null;
        try (DigestInputStream fis = new DigestInputStream(new BufferedInputStream(new FileInputStream(file)), messageDigest);){
            byte[] buffer = new byte[4096];
            while (((InputStream)fis).read(buffer) != -1) {
            }
            byte[] digest = messageDigest.digest();
            return ChecksumHelper.toHexString(digest);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static MessageDigest getMessageDigest(String algorithm, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (providerName == null) {
            return MessageDigest.getInstance(algorithm);
        }
        Provider provider = (Provider)ServiceHelper.getService((BundleContext)Activator.getContext(), Provider.class, (String)("(providerName=" + providerName + ")"));
        if (provider == null) {
            throw new NoSuchProviderException(NLS.bind((String)Messages.noSuchProvider, (Object)providerName));
        }
        return MessageDigest.getInstance(algorithm, provider);
    }
}

