/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;
import org.eclipse.equinox.bidi.internal.StructuredTextActivator;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextComma;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextEmail;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextFile;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextJava;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextRegex;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextSql;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextURL;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextUnderscore;
import org.eclipse.equinox.bidi.internal.consumable.StructuredTextXPath;

public class StructuredTextTypesCollector
implements IRegistryEventListener {
    private static final String EXT_POINT = "org.eclipse.equinox.bidi.bidiTypes";
    private static final String CE_NAME = "typeDescription";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_HANDLER = "class";
    private Map<String, StructuredTextTypeHandler> types;
    private Map<String, IConfigurationElement> factories;
    private static StructuredTextTypesCollector instance = new StructuredTextTypesCollector();

    private StructuredTextTypesCollector() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            registry.addListener((IRegistryEventListener)this, EXT_POINT);
        }
    }

    public static StructuredTextTypesCollector getInstance() {
        return instance;
    }

    public String[] getTypes() {
        if (this.types == null) {
            this.read();
        }
        int size = this.types.size();
        String[] result = new String[size];
        this.types.keySet().toArray(result);
        return result;
    }

    public StructuredTextTypeHandler getHandler(String type) {
        StructuredTextTypeHandler handler;
        if (this.types == null) {
            this.read();
        }
        if ((handler = this.types.get(type)) instanceof StructuredTextTypeHandler) {
            return handler;
        }
        return null;
    }

    private void read() {
        if (this.types == null) {
            this.types = new HashMap<String, StructuredTextTypeHandler>();
        } else {
            this.types.clear();
        }
        if (this.factories == null) {
            this.factories = new HashMap<String, IConfigurationElement>();
        } else {
            this.factories.clear();
        }
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry == null) {
            this.types.putAll(StructuredTextTypesCollector.getDefaultTypeHandlers());
            return;
        }
        IExtensionPoint extPoint = registry.getExtensionPoint(EXT_POINT);
        IExtension[] iExtensionArray = extPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block11: {
                    Object handler;
                    IConfigurationElement confElement = iConfigurationElementArray[n4];
                    if (!CE_NAME.equals(confElement.getName())) {
                        StructuredTextActivator.logError("BiDi types: unexpected element name " + confElement.getName(), new IllegalArgumentException());
                    }
                    String type = confElement.getAttribute(ATTR_TYPE);
                    try {
                        handler = confElement.createExecutableExtension(ATTR_HANDLER);
                    }
                    catch (CoreException e) {
                        StructuredTextActivator.logError("BiDi types: unable to create handler for " + type, (Exception)((Object)e));
                        break block11;
                    }
                    if (handler instanceof StructuredTextTypeHandler) {
                        this.types.put(type, (StructuredTextTypeHandler)handler);
                        this.factories.put(type, confElement);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void added(IExtension[] extensions) {
        this.types = null;
        this.factories = null;
    }

    public void removed(IExtension[] extensions) {
        this.types = null;
        this.factories = null;
    }

    public void added(IExtensionPoint[] extensionPoints) {
        this.types = null;
        this.factories = null;
    }

    public void removed(IExtensionPoint[] extensionPoints) {
        this.types = null;
        this.factories = null;
    }

    public static Map<String, StructuredTextTypeHandler> getDefaultTypeHandlers() {
        LinkedHashMap<String, StructuredTextTypeHandler> types = new LinkedHashMap<String, StructuredTextTypeHandler>();
        types.put("comma", new StructuredTextComma());
        types.put("email", new StructuredTextEmail());
        types.put("file", new StructuredTextFile());
        types.put("java", new StructuredTextJava());
        types.put("regex", new StructuredTextRegex());
        types.put("sql", new StructuredTextSql());
        types.put("underscore", new StructuredTextUnderscore());
        types.put("url", new StructuredTextURL());
        types.put("xpath", new StructuredTextXPath());
        return Collections.unmodifiableMap(types);
    }
}

