/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.examples.PGPExampleUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public class SignedFileProcessor {
    private static void verifyFile(InputStream inputStream, InputStream inputStream2) throws Exception {
        int n;
        inputStream = PGPUtil.getDecoderStream(inputStream);
        JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream);
        PGPCompressedData pGPCompressedData = (PGPCompressedData)jcaPGPObjectFactory.nextObject();
        jcaPGPObjectFactory = new JcaPGPObjectFactory(pGPCompressedData.getDataStream());
        PGPOnePassSignatureList pGPOnePassSignatureList = (PGPOnePassSignatureList)jcaPGPObjectFactory.nextObject();
        PGPOnePassSignature pGPOnePassSignature = pGPOnePassSignatureList.get(0);
        PGPLiteralData pGPLiteralData = (PGPLiteralData)jcaPGPObjectFactory.nextObject();
        InputStream inputStream3 = pGPLiteralData.getInputStream();
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(inputStream2), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey pGPPublicKey = pGPPublicKeyRingCollection.getPublicKey(pGPOnePassSignature.getKeyID());
        FileOutputStream fileOutputStream = new FileOutputStream(pGPLiteralData.getFileName());
        pGPOnePassSignature.init(new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pGPPublicKey);
        while ((n = inputStream3.read()) >= 0) {
            pGPOnePassSignature.update((byte)n);
            fileOutputStream.write(n);
        }
        fileOutputStream.close();
        PGPSignatureList pGPSignatureList = (PGPSignatureList)jcaPGPObjectFactory.nextObject();
        if (pGPOnePassSignature.verify(pGPSignatureList.get(0))) {
            System.out.println("signature verified.");
        } else {
            System.out.println("signature verification failed.");
        }
    }

    private static void signFile(String string, InputStream inputStream, OutputStream outputStream, char[] cArray, boolean bl) throws IOException, PGPException {
        int n;
        Object object;
        if (bl) {
            outputStream = new ArmoredOutputStream(outputStream);
        }
        PGPSecretKey pGPSecretKey = PGPExampleUtil.readSecretKey(inputStream);
        PGPPrivateKey pGPPrivateKey = pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(cArray));
        PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(new JcaPGPContentSignerBuilder(pGPSecretKey.getPublicKey().getAlgorithm(), 2).setProvider("BC"));
        pGPSignatureGenerator.init(0, pGPPrivateKey);
        Iterator<String> iterator = pGPSecretKey.getPublicKey().getUserIDs();
        if (iterator.hasNext()) {
            object = new PGPSignatureSubpacketGenerator();
            ((PGPSignatureSubpacketGenerator)object).addSignerUserID(false, iterator.next());
            pGPSignatureGenerator.setHashedSubpackets(((PGPSignatureSubpacketGenerator)object).generate());
        }
        object = new PGPCompressedDataGenerator(2);
        BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(((PGPCompressedDataGenerator)object).open(outputStream));
        pGPSignatureGenerator.generateOnePassVersion(false).encode(bCPGOutputStream);
        File file = new File(string);
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open(bCPGOutputStream, 'b', file);
        FileInputStream fileInputStream = new FileInputStream(file);
        while ((n = fileInputStream.read()) >= 0) {
            outputStream2.write(n);
            pGPSignatureGenerator.update((byte)n);
        }
        pGPLiteralDataGenerator.close();
        pGPSignatureGenerator.generate().encode(bCPGOutputStream);
        ((PGPCompressedDataGenerator)object).close();
        if (bl) {
            outputStream.close();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (stringArray[0].equals("-s")) {
            if (stringArray[1].equals("-a")) {
                FileInputStream fileInputStream = new FileInputStream(stringArray[3]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2] + ".asc");
                SignedFileProcessor.signFile(stringArray[2], fileInputStream, fileOutputStream, stringArray[4].toCharArray(), true);
            } else {
                FileInputStream fileInputStream = new FileInputStream(stringArray[2]);
                FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1] + ".bpg");
                SignedFileProcessor.signFile(stringArray[1], fileInputStream, fileOutputStream, stringArray[3].toCharArray(), false);
            }
        } else if (stringArray[0].equals("-v")) {
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            FileInputStream fileInputStream2 = new FileInputStream(stringArray[2]);
            SignedFileProcessor.verifyFile(fileInputStream, fileInputStream2);
        } else {
            System.err.println("usage: SignedFileProcessor -v|-s [-a] file keyfile [passPhrase]");
        }
    }
}

