/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property.map;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.map.MapProperty;
import org.eclipse.core.databinding.property.map.SimpleMapProperty;

public abstract class DelegatingMapProperty<S, K, V>
extends MapProperty<S, K, V> {
    private final Object keyType;
    private final Object valueType;
    private final IMapProperty<S, K, V> nullProperty = new NullMapProperty();

    protected DelegatingMapProperty() {
        this(null, null);
    }

    protected DelegatingMapProperty(Object keyType, Object valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public final IMapProperty<S, K, V> getDelegate(S source) {
        if (source == null) {
            return this.nullProperty;
        }
        IMapProperty<S, K, V> delegate = this.doGetDelegate(source);
        if (delegate == null) {
            delegate = this.nullProperty;
        }
        return delegate;
    }

    protected abstract IMapProperty<S, K, V> doGetDelegate(S var1);

    @Override
    public Object getKeyType() {
        return this.keyType;
    }

    @Override
    public Object getValueType() {
        return this.valueType;
    }

    @Override
    protected Map<K, V> doGetMap(S source) {
        return this.getDelegate(source).getMap(source);
    }

    @Override
    protected void doSetMap(S source, Map<K, V> map) {
        this.getDelegate(source).setMap(source, map);
    }

    @Override
    protected void doUpdateMap(S source, MapDiff<K, V> diff) {
        this.getDelegate(source).updateMap(source, diff);
    }

    @Override
    public IObservableMap<K, V> observe(S source) {
        return this.getDelegate(source).observe(source);
    }

    @Override
    public IObservableMap<K, V> observe(Realm realm, S source) {
        return this.getDelegate(source).observe(realm, source);
    }

    private class NullMapProperty
    extends SimpleMapProperty<S, K, V> {
        private NullMapProperty() {
        }

        @Override
        protected Map<K, V> doGetMap(Object source) {
            return Collections.emptyMap();
        }

        @Override
        protected void doSetMap(S source, Map<K, V> map, MapDiff<K, V> diff) {
        }

        @Override
        protected void doSetMap(S source, Map<K, V> map) {
        }

        @Override
        protected void doUpdateMap(S source, MapDiff<K, V> diff) {
        }

        @Override
        public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, MapDiff<K, V>> listener) {
            return null;
        }

        @Override
        public Object getKeyType() {
            return DelegatingMapProperty.this.keyType;
        }

        @Override
        public Object getValueType() {
            return DelegatingMapProperty.this.valueType;
        }
    }
}

