/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositoryNameAndLocationDialog;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class AddRepositoryDialog
extends RepositoryNameAndLocationDialog {
    URI addedLocation;
    static final String[] ARCHIVE_EXTENSIONS = new String[]{"*.jar;*.zip"};
    static String lastLocalLocation = null;
    static String lastArchiveLocation = null;
    Policy policy;

    public AddRepositoryDialog(Shell parentShell, ProvisioningUI ui) {
        super(parentShell, ui);
        this.setTitle(ProvUIMessages.AddRepositoryDialog_Title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentShell, "org.eclipse.equinox.p2.ui.add_repository_dialog_context");
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.initializeDialogUnits((Control)comp);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginTop = this.convertVerticalDLUsToPixels(4);
        comp.setLayout((Layout)layout);
        GridData data = new GridData(768);
        comp.setLayoutData((Object)data);
        this.nickname = this.createNameField(comp);
        Button localButton = new Button(comp, 8);
        localButton.setText(ProvUIMessages.RepositoryGroup_LocalRepoBrowseButton);
        localButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 65536);
            dialog.setMessage(ProvUIMessages.RepositoryGroup_SelectRepositoryDirectory);
            dialog.setFilterPath(lastLocalLocation);
            String path = dialog.open();
            if (path != null) {
                lastLocalLocation = path;
                this.url.setText(this.makeLocalURIString(path));
                this.validateRepositoryURL(false);
            }
        }));
        this.setButtonLayoutData(localButton);
        this.url = this.createLocationField(comp);
        Button archiveButton = new Button(comp, 8);
        archiveButton.setText(ProvUIMessages.RepositoryGroup_ArchivedRepoBrowseButton);
        archiveButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            FileDialog dialog = new FileDialog(this.getShell(), 65536);
            dialog.setText(ProvUIMessages.RepositoryGroup_RepositoryFile);
            dialog.setFilterExtensions(ARCHIVE_EXTENSIONS);
            dialog.setFileName(lastArchiveLocation);
            String path = dialog.open();
            if (path != null) {
                lastArchiveLocation = path;
                this.url.setText(this.makeLocalURIString(path));
                this.validateRepositoryURL(false);
            }
        }));
        this.setButtonLayoutData(archiveButton);
        comp.setTabList(new Control[]{this.nickname, this.url, localButton, archiveButton});
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    String makeLocalURIString(String path) {
        try {
            URI localURI = URIUtil.fromString((String)path);
            return URIUtil.toUnencodedString((URI)RepositoryHelper.localRepoURIHelper((URI)localURI));
        }
        catch (URISyntaxException e) {
            return path;
        }
    }

    @Override
    protected boolean handleOk() {
        IStatus status = this.addRepository();
        return status.isOK();
    }

    public URI getAddedLocation() {
        return this.addedLocation;
    }

    protected IStatus addRepository() {
        IStatus status = this.validateRepositoryURL(false);
        if (status.isOK()) {
            this.addedLocation = this.getUserLocation();
            String nick = this.nickname.getText().trim();
            if (nick.length() == 0) {
                nick = null;
            }
            this.getRepositoryTracker().addRepository(this.addedLocation, nick, this.getProvisioningUI().getSession());
        }
        return status;
    }

    protected boolean isResizable() {
        return true;
    }
}

