/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt.handlers;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.E4WorkbenchSWTMessages;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.urischeme.IUriSchemeHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class EclipseCommandURIHandler
implements IUriSchemeHandler {
    public void handle(String uriString) {
        URI uri = URI.create(uriString);
        String commandId = uri.getHost();
        BundleContext bundleContext = FrameworkUtil.getBundle(IWorkbench.class).getBundleContext();
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext).getActiveLeaf();
        ECommandService commandService = (ECommandService)context.get(ECommandService.class);
        EHandlerService eHandlerService = (EHandlerService)context.get(EHandlerService.class);
        Command command = commandService.getCommand(commandId);
        String query = uri.getRawQuery();
        if (query == null) {
            query = "";
        }
        Map<String, String> uriParams = Arrays.stream(query.split("&")).filter(s -> !s.isEmpty()).map(param -> param.split("=")).collect(Collectors.toMap(segments -> URLDecoder.decode(segments[0], StandardCharsets.UTF_8), segments -> URLDecoder.decode(segments[1], StandardCharsets.UTF_8)));
        ParameterizedCommand parametrizedCommand = ParameterizedCommand.generateCommand((Command)command, uriParams);
        Display.getDefault().asyncExec(() -> {
            String commandName = E4WorkbenchSWTMessages.openCommandFromUIHandler_undefined;
            try {
                commandName = command.getName();
            }
            catch (NotDefinedException notDefinedException) {
                // empty catch block
            }
            if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)E4WorkbenchSWTMessages.openCommandFromURIHandler_confirm_title, (String)NLS.bind((String)E4WorkbenchSWTMessages.openCommandFromURIHandler_confirm_message, (Object)uri, (Object)commandName))) {
                eHandlerService.executeHandler(parametrizedCommand);
            }
        });
    }
}

