/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core.user;

import org.eclipse.passage.lic.users.model.api.User;
import org.eclipse.passage.lic.users.model.api.UserOrigin;
import org.eclipse.passage.loc.yars.internal.api.DosHandleMedia;
import org.eclipse.passage.loc.yars.internal.api.ExportData;
import org.eclipse.passage.loc.yars.internal.api.Progress;

public final class ProductCustomer
implements ExportData<ProductCustomer, DosHandleMedia<ProductCustomer>> {
    private final String name;
    private final String contact;
    private final Usage usage;

    public ProductCustomer(User user) {
        this(user.getContact().getName(), user.getContact().getEmail(), Usage.personal);
    }

    public ProductCustomer(UserOrigin company) {
        this(company.getName(), "", Usage.company);
    }

    public ProductCustomer(String name, String contact, Usage usage) {
        this.name = name;
        this.contact = contact;
        this.usage = usage;
    }

    public void write(DosHandleMedia<ProductCustomer> media, Progress<ProductCustomer> progress) {
        media.inner(this.name, "name");
        media.inner(this.usage.name(), "usage");
        media.inner(this.contact, "contact");
    }

    public String toString() {
        return String.format("%s [%s] (%s)", this.name, this.usage.name(), this.contact);
    }

    public static enum Usage {
        personal,
        company;

    }
}

