/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.protocol.BasicUIElement;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.core.protocol.IMLSelectData;
import org.eclipse.rcptt.tesla.core.protocol.IUIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectData;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.UpdateControlCommand;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;

public class UISelector<T extends BasicUIElement> {
    private GenericElementKind kind;
    private IUIPlayer player;
    Element parent;
    Element after;
    private List<String> path;
    private List<Integer> indexes;
    private String classPattern;
    private Class<T> caster;
    private byte[] image;

    public UISelector(ElementKind kind, IUIPlayer player, Class<T> caster) {
        this(new GenericElementKind(kind), player, caster);
    }

    public UISelector(String customKindId, IUIPlayer player, Class<T> caster) {
        this(new GenericElementKind(customKindId), player, caster);
    }

    public UISelector(GenericElementKind kind, IUIPlayer player, Class<T> caster) {
        this.kind = kind;
        this.player = player;
        this.caster = caster;
    }

    public Element getParent() {
        return this.parent;
    }

    void setCopy(UISelector<T> sel) {
        this.kind = sel.kind;
        this.player = sel.player;
        this.parent = sel.parent;
        this.after = sel.after;
        if (sel.path != null) {
            this.path = new ArrayList<String>(sel.path);
        }
        if (sel.indexes != null) {
            this.indexes = new ArrayList<Integer>(sel.indexes);
        }
        this.classPattern = sel.classPattern;
        this.caster = sel.caster;
        this.image = sel.image;
    }

    public UISelector<T> parent(Element parent) {
        if (parent == null && this.parent == null) {
            return this;
        }
        UISelector<T> ns = this.copy();
        ns.parent = parent;
        return ns;
    }

    public UISelector<T> classPattern(String pattern) {
        if (pattern == null && this.classPattern == null) {
            return this;
        }
        UISelector<T> ns = this.copy();
        ns.classPattern = pattern;
        return ns;
    }

    public UISelector<T> image(byte[] image) {
        UISelector<T> ns = this.copy();
        ns.image = image;
        return ns;
    }

    public UISelector<T> after(Element after) {
        Assert.isNotNull((Object)after);
        UISelector<T> ns = this.copy();
        Assert.isNotNull((Object)after);
        ns.after = after;
        return ns;
    }

    public UISelector<T> after(BasicUIElement after) {
        Assert.isNotNull((Object)after);
        UISelector<T> ns = this.copy();
        Assert.isNotNull((Object)after);
        Assert.isNotNull((Object)after.getElement());
        ns.after = after.getElement();
        return ns;
    }

    private UISelector<T> copy() {
        UISelector<T> ns = new UISelector<T>(this.kind, this.player, this.caster);
        ns.setCopy(this);
        return ns;
    }

    public UISelector<T> after(UISelector<?> after) {
        UISelector<T> ns = this.copy();
        Object sel = after.find();
        if (sel != null) {
            ns.after = ((BasicUIElement)sel).element;
        }
        return ns;
    }

    public UISelector<T> path(String ... path) {
        UISelector<T> ns = this.copy();
        ns.path = path != null ? Arrays.asList(path) : null;
        return ns;
    }

    public UISelector<T> pathList(List<String> path) {
        UISelector<T> ns = this.copy();
        ns.path = path;
        return ns;
    }

    public UISelector<T> indexes(Integer ... path) {
        UISelector<T> ns = this.copy();
        ns.indexes = path != null ? Arrays.asList(path) : null;
        return ns;
    }

    public UISelector<T> indexesList(List<Integer> indexes) {
        UISelector<T> ns = this.copy();
        ns.indexes = indexes;
        return ns;
    }

    public T find() {
        return this.find(null, null);
    }

    public T find(Integer index) {
        return this.find(null, index);
    }

    public T find(String pattern) {
        return this.find(pattern, null);
    }

    public T find(String pattern, Integer index) {
        SelectResponse selectResponse;
        Response response;
        SelectCommand cmd = ProtocolFactory.eINSTANCE.createSelectCommand();
        SelectData data = null;
        if (this.image != null) {
            IMLSelectData imageData = ProtocolFactory.eINSTANCE.createIMLSelectData();
            data = imageData;
            imageData.setImage(this.image);
        } else {
            data = ProtocolFactory.eINSTANCE.createSelectData();
        }
        cmd.setData(data);
        data.setPattern(pattern);
        if (this.path != null) {
            data.getPath().addAll(this.path);
        }
        data.setParent(this.parent != null ? (Element)EcoreUtil.copy((EObject)this.parent) : null);
        data.setAfter(this.after != null ? (Element)EcoreUtil.copy((EObject)this.after) : null);
        data.setKind(this.kind.name());
        data.setIndex(index);
        data.setMultiplicity(1);
        data.setClassPattern(this.classPattern);
        if (this.indexes != null) {
            data.getIndexes().addAll(this.indexes);
        }
        if ((response = this.player.safeExecuteCommand(cmd)) == null) {
            return null;
        }
        if (response instanceof SelectResponse && (selectResponse = (SelectResponse)response).getStatus().equals((Object)ResponseStatus.OK)) {
            block9: {
                if (!selectResponse.getElements().isEmpty()) break block9;
                return null;
            }
            try {
                Constructor<T> constructor = this.caster.getConstructor(Element.class, UIPlayer.class);
                BasicUIElement instance = (BasicUIElement)constructor.newInstance(selectResponse.getElements().get(0), this.player);
                return (T)instance;
            }
            catch (Throwable e) {
                TeslaCore.log(e);
            }
        }
        return null;
    }

    public void update(Element element) {
        UpdateControlCommand cmd = ProtocolFactory.eINSTANCE.createUpdateControlCommand();
        cmd.setElements(element);
        this.player.safeExecuteCommand(cmd);
    }
}

