/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.hnsw;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;

public class DefaultFlatVectorScorer
implements FlatVectorsScorer {
    public static final DefaultFlatVectorScorer INSTANCE = new DefaultFlatVectorScorer();

    @Override
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues) throws IOException {
        switch (vectorValues.getEncoding()) {
            case FLOAT32: {
                return new FloatScoringSupplier((FloatVectorValues)vectorValues, similarityFunction);
            }
            case BYTE: {
                return new ByteScoringSupplier((ByteVectorValues)vectorValues, similarityFunction);
            }
        }
        throw new IllegalArgumentException("vectorValues must be an instance of FloatVectorValues or ByteVectorValues, got a " + vectorValues.getClass().getName());
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, float[] target) throws IOException {
        assert (vectorValues instanceof FloatVectorValues);
        if (target.length != vectorValues.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + target.length + " differs from field dimension: " + vectorValues.dimension());
        }
        return new FloatVectorScorer((FloatVectorValues)vectorValues, target, similarityFunction);
    }

    @Override
    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, KnnVectorValues vectorValues, byte[] target) throws IOException {
        assert (vectorValues instanceof ByteVectorValues);
        if (target.length != vectorValues.dimension()) {
            throw new IllegalArgumentException("vector query dimension: " + target.length + " differs from field dimension: " + vectorValues.dimension());
        }
        return new ByteVectorScorer((ByteVectorValues)vectorValues, target, similarityFunction);
    }

    public String toString() {
        return "DefaultFlatVectorScorer()";
    }

    private static final class FloatScoringSupplier
    implements RandomVectorScorerSupplier {
        private final FloatVectorValues vectors;
        private final FloatVectorValues vectors1;
        private final FloatVectorValues vectors2;
        private final VectorSimilarityFunction similarityFunction;

        private FloatScoringSupplier(FloatVectorValues vectors, VectorSimilarityFunction similarityFunction) throws IOException {
            this.vectors = vectors;
            this.vectors1 = vectors.copy();
            this.vectors2 = vectors.copy();
            this.similarityFunction = similarityFunction;
        }

        @Override
        public RandomVectorScorer scorer(final int ord) {
            return new RandomVectorScorer.AbstractRandomVectorScorer(this.vectors){

                @Override
                public float score(int node) throws IOException {
                    return similarityFunction.compare(vectors1.vectorValue(ord), vectors2.vectorValue(node));
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new FloatScoringSupplier(this.vectors, this.similarityFunction);
        }

        public String toString() {
            return "FloatScoringSupplier(similarityFunction=" + String.valueOf((Object)this.similarityFunction) + ")";
        }
    }

    private static final class ByteScoringSupplier
    implements RandomVectorScorerSupplier {
        private final ByteVectorValues vectors;
        private final ByteVectorValues vectors1;
        private final ByteVectorValues vectors2;
        private final VectorSimilarityFunction similarityFunction;

        private ByteScoringSupplier(ByteVectorValues vectors, VectorSimilarityFunction similarityFunction) throws IOException {
            this.vectors = vectors;
            this.vectors1 = vectors.copy();
            this.vectors2 = vectors.copy();
            this.similarityFunction = similarityFunction;
        }

        @Override
        public RandomVectorScorer scorer(final int ord) {
            return new RandomVectorScorer.AbstractRandomVectorScorer(this.vectors){

                @Override
                public float score(int node) throws IOException {
                    return similarityFunction.compare(vectors1.vectorValue(ord), vectors2.vectorValue(node));
                }
            };
        }

        @Override
        public RandomVectorScorerSupplier copy() throws IOException {
            return new ByteScoringSupplier(this.vectors, this.similarityFunction);
        }

        public String toString() {
            return "ByteScoringSupplier(similarityFunction=" + String.valueOf((Object)this.similarityFunction) + ")";
        }
    }

    private static class FloatVectorScorer
    extends RandomVectorScorer.AbstractRandomVectorScorer {
        private final FloatVectorValues values;
        private final float[] query;
        private final VectorSimilarityFunction similarityFunction;

        public FloatVectorScorer(FloatVectorValues values, float[] query, VectorSimilarityFunction similarityFunction) {
            super(values);
            this.values = values;
            this.query = query;
            this.similarityFunction = similarityFunction;
        }

        @Override
        public float score(int node) throws IOException {
            return this.similarityFunction.compare(this.query, this.values.vectorValue(node));
        }
    }

    private static class ByteVectorScorer
    extends RandomVectorScorer.AbstractRandomVectorScorer {
        private final ByteVectorValues values;
        private final byte[] query;
        private final VectorSimilarityFunction similarityFunction;

        public ByteVectorScorer(ByteVectorValues values, byte[] query, VectorSimilarityFunction similarityFunction) {
            super(values);
            this.values = values;
            this.query = query;
            this.similarityFunction = similarityFunction;
        }

        @Override
        public float score(int node) throws IOException {
            return this.similarityFunction.compare(this.query, this.values.vectorValue(node));
        }
    }
}

