/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.resources.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.resources.internal.impl.Activator;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceData;
import org.eclipse.rcptt.workspace.WorkspaceFactory;

public class WSCaptureUtils {
    public static void capture(final IWorkspace workspace, WorkspaceData data) throws CoreException {
        final WSRoot root = WorkspaceFactory.eINSTANCE.createWSRoot();
        data.setContent(root);
        workspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject[] projects;
                IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject iProject = iProjectArray[n2];
                    if (iProject.exists() && iProject.isOpen()) {
                        iProject.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        WSProject wsProject = WSUtils.getProject((WSRoot)root, (String)iProject.getName(), (boolean)true);
                        root.getProjects().add((Object)wsProject);
                        WSCaptureUtils.doCapture((WSFolder)wsProject, (IContainer)iProject);
                    }
                    ++n2;
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void doCapture(WSFolder folder, IContainer iContainer) throws CoreException {
        IResource[] iResourceArray = iContainer.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource iResource = iResourceArray[n2];
            String name = iResource.getName();
            if (iResource instanceof IFolder) {
                WSFolder child = WSUtils.getFolder((WSFolder)folder, (String)name, (boolean)true);
                WSCaptureUtils.doCapture(child, (IContainer)((IFolder)iResource));
            } else if (iResource instanceof IFile) {
                IFile iFile = (IFile)iResource;
                IPath iPath = iFile.getLocation();
                if (!iFile.isLocal(0)) {
                    Activator.logWarn("Cannot retrieve contents of a file %s (%s). File skipped.", name, iFile.getLocation());
                } else {
                    File jfile;
                    WSFile child = WSUtils.getFile((WSFolder)folder, (String)name, (boolean)true);
                    if (iPath != null && (jfile = iPath.toFile()).canExecute()) {
                        child.setExecutable(true);
                    }
                    WSCaptureUtils.makeExecutableData(child, iFile);
                }
            }
            ++n2;
        }
    }

    private static void makeExecutableData(WSFile child, IFile iFile) {
        if ("false".equals(Q7Features.getInstance().getValue("q7.contexts.resources.transfer.content"))) {
            return;
        }
        try {
            InputStream contents = iFile.getContents();
            byte[] content = WSUtils.getStreamContent((InputStream)contents);
            contents.close();
            if (Q7Features.getInstance().isTrue("q7.contexts.resources.transfer.zipped")) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ZipOutputStream zout = new ZipOutputStream(bout);
                zout.setLevel(9);
                zout.setMethod(8);
                ZipEntry entry = new ZipEntry("content");
                entry.setTime(1L);
                zout.putNextEntry(entry);
                zout.write(content);
                zout.close();
                child.setContent(bout.toByteArray());
            } else {
                child.setContent(content);
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }
}

