/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.features.model;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.WorkspaceProductModel;

public class WorkspaceProductModelManager
extends WorkspaceModelManager<Collection<IProductModel>> {
    public static final String PRODUCT_FILENAME_SUFFIX = ".product";

    protected IEclipsePreferences.IPreferenceChangeListener createBundleRootChangeListener() {
        return null;
    }

    protected boolean isInterestingProject(IProject project) {
        return project.isOpen() && !WorkspaceProductModelManager.findProductFiles((IContainer)project, false).isEmpty();
    }

    protected boolean isInterestingFolder(IFolder folder) {
        return !folder.isDerived() || JavaCore.create((IProject)folder.getProject()).isOnClasspath((IResource)folder);
    }

    protected void createModel(IProject project, boolean notify) {
        for (IFile product : WorkspaceProductModelManager.findProductFiles((IContainer)project, true)) {
            this.createSingleModel(project, product, notify);
        }
    }

    private void createSingleModel(IProject project, IFile product, boolean notify) {
        WorkspaceProductModel model = new WorkspaceProductModel(product, true);
        this.loadModel((IModel)model, false);
        Collection models = this.getModelsMap().computeIfAbsent(project, key -> new ArrayList());
        models.add(model);
        if (notify) {
            this.addChange((IModel)model, 1);
        }
    }

    protected Collection<IProductModel> removeModel(IProject project) {
        Collection models = (Collection)this.getModelsMap().remove(project);
        if (models != null) {
            for (IProductModel model : models) {
                this.addChange((IModel)model, 2);
            }
        }
        return models;
    }

    private Collection<IProductModel> removeSingleModel(IProject project, IProductModel model) {
        Collection models = (Collection)this.getModelsMap().get(project);
        if (models != null) {
            if (models.remove(model)) {
                this.addChange((IModel)model, 2);
            }
            if (models.isEmpty()) {
                this.getModelsMap().remove(project);
            }
        }
        return models;
    }

    private IProductModel getSingleModel(IFile productFile) {
        Collection models = (Collection)this.getModel(productFile.getProject());
        if (models != null) {
            for (IProductModel model : models) {
                if (!model.getUnderlyingResource().equals((Object)productFile)) continue;
                return model;
            }
        }
        return null;
    }

    protected void handleFileDelta(IResourceDelta delta) {
        if (WorkspaceProductModelManager.isProductFile(delta.getResource())) {
            IFile file = (IFile)delta.getResource();
            IProject project = file.getProject();
            IProductModel model = this.getSingleModel(file);
            int kind = delta.getKind();
            if (kind == 2 && model != null) {
                this.removeSingleModel(project, model);
            } else if (kind == 1 && model == null) {
                this.createSingleModel(project, file, true);
            } else if (kind == 4 && (0x100 & delta.getFlags()) != 0) {
                this.loadModel((IModel)model, true);
                this.addChange((IModel)model, 4);
            }
        }
    }

    protected IProductModel[] getProductModels() {
        this.initialize();
        ArrayList flattenedModels = new ArrayList();
        for (Collection models : this.getModelsMap().values()) {
            flattenedModels.addAll(models);
        }
        return flattenedModels.toArray(new IProductModel[flattenedModels.size()]);
    }

    private static boolean isProductFile(IResourceProxy proxy) {
        return proxy.getType() == 1 && proxy.getName().endsWith(PRODUCT_FILENAME_SUFFIX);
    }

    private static boolean isProductFile(IResource resource) {
        return resource.getType() == 1 && resource.getName().endsWith(PRODUCT_FILENAME_SUFFIX);
    }

    private static Collection<IFile> findProductFiles(IContainer container, boolean findAll) {
        try {
            ArrayList<IFile> products = new ArrayList<IFile>();
            container.accept(proxy -> {
                if (WorkspaceProductModelManager.isProductFile(proxy) && (findAll || products.isEmpty())) {
                    products.add((IFile)proxy.requestResource());
                }
                return findAll || products.isEmpty();
            }, 0);
            return products;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

