/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Serialized;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.ecl.runtime.IEMFConverter;

public enum EMFConverterManager implements IEMFConverter<Object, EObject>
{
    INSTANCE;

    private static final String EXTPT = "org.eclipse.rcptt.ecl.core.emfConverters";
    private static final String CLASS_ATTR = "class";
    private Map<Class<?>, IEMFConverter<?, ?>> byJavaClass = new HashMap();
    private Map<EClass, IEMFConverter<?, ?>> byEClass = new HashMap();

    private EMFConverterManager() {
        IConfigurationElement[] configs;
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTPT);
        int n2 = configs.length;
        int n3 = 0;
        while (n3 < n2) {
            IConfigurationElement config = iConfigurationElementArray[n3];
            try {
                Object object = config.createExecutableExtension(CLASS_ATTR);
                if (object instanceof IEMFConverter) {
                    IEMFConverter converter = (IEMFConverter)object;
                    Class javaClass = converter.getJavaClass();
                    this.byJavaClass.put(javaClass, converter);
                    EClass eClass = converter.getEClass();
                    this.byEClass.put(eClass, converter);
                }
            }
            catch (CoreException e) {
                CorePlugin.getDefault().getLog().log(e.getStatus());
            }
            ++n3;
        }
    }

    @Override
    public EObject toEObject(Object object) throws CoreException {
        IEMFConverter<?, ?> serializer = this.byJavaClass.get(object.getClass());
        if (serializer == null) {
            serializer = this.guessConverter(object.getClass());
        }
        if (serializer == null) {
            if (object instanceof Serializable) {
                return this.serializeObject(object);
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.core", "Serialization is not supported for instances of: " + object.getClass().getName()));
        }
        return serializer.toEObject(object);
    }

    private IEMFConverter<?, ?> guessConverter(Class<?> clazz) {
        IEMFConverter<?, ?> result = null;
        int score = Integer.MAX_VALUE;
        for (Map.Entry<Class<?>, IEMFConverter<?, ?>> entry : this.byJavaClass.entrySet()) {
            int tmp = EMFConverterManager.getDistance(clazz, entry.getKey());
            if (tmp >= score) continue;
            score = tmp;
            result = entry.getValue();
        }
        return result;
    }

    public static int getDistance(Class<?> from, Class<?> to) {
        return EMFConverterManager.getDistance(from, to, 0);
    }

    private static int getDistance(Class<?> from, Class<?> to, int level) {
        if (from.equals(to)) {
            return level;
        }
        if (!to.isAssignableFrom(from)) {
            return Integer.MAX_VALUE;
        }
        int result = from.getSuperclass() == null ? Integer.MAX_VALUE : EMFConverterManager.getDistance(from.getSuperclass(), to, level + 1);
        Class<?>[] classArray = from.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iface = classArray[n2];
            int tmp = EMFConverterManager.getDistance(iface, to, level + 1);
            if (tmp < result) {
                result = tmp;
            }
            ++n2;
        }
        return result;
    }

    private EObject serializeObject(Object object) throws CoreException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new ObjectOutputStream(out).writeObject(object);
            out.flush();
            out.close();
            Serialized serialized = CoreFactory.eINSTANCE.createSerialized();
            serialized.setBytes(out.toByteArray());
            return serialized;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.core", "Failed to serialize object"));
        }
    }

    @Override
    public Object fromEObject(EObject eObject) throws CoreException {
        IEMFConverter<?, ?> deserializer = this.byEClass.get(eObject.eClass());
        if (deserializer == null) {
            if (eObject instanceof Serialized) {
                return this.deserializeObject((Serialized)eObject);
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.core", "Deserialization is not supported for instances of: " + eObject.eClass().getName()));
        }
        return deserializer.fromEObject(eObject);
    }

    private Object deserializeObject(Serialized serialized) throws CoreException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(serialized.getBytes());
            return new ObjectInputStream(in).readObject();
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.rcptt.ecl.core", "Failed to deserialize object"));
        }
    }

    @Override
    public Class<Object> getJavaClass() {
        return Object.class;
    }

    @Override
    public EClass getEClass() {
        return EcorePackage.Literals.EOBJECT;
    }
}

