/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public abstract class JavadocTagsBaseSubProcessor<T> {
    protected JavadocTagsBaseSubProcessor() {
    }

    public void addMissingJavadocTagProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        this.addMissingJavadocTagProposals(context, node, proposals);
    }

    public void addMissingJavadocTagProposals(IInvocationContext context, ASTNode node, Collection<T> proposals) {
        BodyDeclaration parentDeclaration = null;
        if (node == null) {
            return;
        }
        StructuralPropertyDescriptor location = (node = ASTNodes.getNormalizedNode(node)).getLocationInParent();
        if (location == ModuleDeclaration.MODULE_DIRECTIVES_PROPERTY) {
            String label2;
            T addAllMissing;
            String label;
            if (node instanceof UsesDirective) {
                label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_usestag_description;
            } else if (node instanceof ProvidesDirective) {
                label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_providestag_description;
            } else {
                return;
            }
            ModuleDeclaration moduleDecl = (ModuleDeclaration)node.getParent();
            T proposal = this.addMissingModuleJavadocTagProposal(label, context.getCompilationUnit(), moduleDecl, node, 4);
            if (proposal != null) {
                proposals.add(proposal);
            }
            if ((addAllMissing = this.addAllMissingModuleJavadocTagsProposal(label2 = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_allmissing_description, context.getCompilationUnit(), moduleDecl, node, 5)) != null) {
                proposals.add(addAllMissing);
            }
        } else {
            String label2;
            T addAllMissing;
            T proposal;
            String label;
            parentDeclaration = ASTResolving.findParentBodyDeclaration(node);
            if (parentDeclaration == null) {
                return;
            }
            Javadoc javadoc = parentDeclaration.getJavadoc();
            if (javadoc == null) {
                return;
            }
            if (location == SingleVariableDeclaration.NAME_PROPERTY) {
                label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_paramtag_description;
                StructuralPropertyDescriptor propDesc = node.getParent().getLocationInParent();
                if (propDesc != MethodDeclaration.PARAMETERS_PROPERTY && propDesc != RecordDeclaration.RECORD_COMPONENTS_PROPERTY) {
                    return;
                }
            } else if (location == TypeParameter.NAME_PROPERTY) {
                label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_paramtag_description;
                StructuralPropertyDescriptor parentLocation = node.getParent().getLocationInParent();
                if (parentLocation != MethodDeclaration.TYPE_PARAMETERS_PROPERTY && parentLocation != TypeDeclaration.TYPE_PARAMETERS_PROPERTY && parentLocation != RecordDeclaration.TYPE_PARAMETERS_PROPERTY) {
                    return;
                }
            } else if (location == MethodDeclaration.RETURN_TYPE2_PROPERTY) {
                label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_returntag_description;
            } else if (location == MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY) {
                label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_throwstag_description;
            } else {
                return;
            }
            if ((proposal = this.addMissingJavadocTagProposal(label, context.getCompilationUnit(), (ASTNode)parentDeclaration, node, 4)) != null) {
                proposals.add(proposal);
            }
            if ((addAllMissing = this.addAllMissingJavadocTagsProposal(label2 = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_allmissing_description, context.getCompilationUnit(), (ASTNode)parentDeclaration, 5)) != null) {
                proposals.add(addAllMissing);
            }
        }
    }

    public void addUnusedAndUndocumentedParameterOrExceptionProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        String label;
        String key;
        ICompilationUnit cu = context.getCompilationUnit();
        IJavaProject project = cu.getJavaProject();
        if (!"enabled".equals(project.getOption("org.eclipse.jdt.core.compiler.doc.comment.support", true))) {
            return;
        }
        int problemId = problem.getProblemId();
        boolean isUnusedTypeParam = problemId == 16777877;
        boolean isUnusedParam = problemId == 536870974 || isUnusedTypeParam;
        String string = key = isUnusedParam ? "org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference" : "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference";
        if (!"enabled".equals(project.getOption(key, true))) {
            return;
        }
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        BodyDeclaration bodyDecl = ASTResolving.findParentBodyDeclaration(node);
        if (bodyDecl == null || ASTResolving.getParentMethodOrTypeBinding((ASTNode)bodyDecl) == null) {
            return;
        }
        if (isUnusedTypeParam) {
            label = CorrectionMessages.JavadocTagsSubProcessor_document_type_parameter_description;
        } else if (isUnusedParam) {
            label = CorrectionMessages.JavadocTagsSubProcessor_document_parameter_description;
        } else {
            node = ASTNodes.getNormalizedNode(node);
            label = CorrectionMessages.JavadocTagsSubProcessor_document_exception_description;
        }
        T proposal = this.addMissingJavadocTagProposal(label, context.getCompilationUnit(), (ASTNode)bodyDecl, node, 1);
        if (proposal != null) {
            proposals.add(proposal);
        }
    }

    public void addMissingJavadocCommentProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) throws CoreException {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        if (node instanceof ModuleDeclaration) {
            String label;
            T p;
            ModuleDeclaration declaration = (ModuleDeclaration)node;
            IModuleBinding binding = declaration.resolveBinding();
            if (binding == null) {
                return;
            }
            ArrayList<String> usesNames = new ArrayList<String>();
            ITypeBinding[] iTypeBindingArray = binding.getUses();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding use = iTypeBindingArray[n2];
                usesNames.add(use.getName());
                ++n2;
            }
            ArrayList<String> providesNames = new ArrayList<String>();
            ITypeBinding[] iTypeBindingArray2 = binding.getServices();
            int n3 = iTypeBindingArray2.length;
            n = 0;
            while (n < n3) {
                ITypeBinding provide = iTypeBindingArray2[n];
                providesNames.add(provide.getName());
                ++n;
            }
            String comment = CodeGeneration.getModuleComment(cu, declaration.getName().getFullyQualifiedName(), providesNames.toArray(new String[0]), usesNames.toArray(new String[0]), String.valueOf('\n'));
            if (comment != null && (p = this.addJavadocCommentProposal(label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_method_description, cu, 1, declaration.getStartPosition(), comment)) != null) {
                proposals.add(p);
            }
        } else {
            BodyDeclaration declaration = ASTResolving.findParentBodyDeclaration(node);
            if (declaration == null) {
                return;
            }
            ITypeBinding binding = Bindings.getBindingOfParentType((ASTNode)declaration);
            if (binding == null) {
                return;
            }
            if (declaration instanceof MethodDeclaration) {
                String label;
                T p;
                String string;
                MethodDeclaration methodDecl = (MethodDeclaration)declaration;
                IMethodBinding methodBinding = methodDecl.resolveBinding();
                IMethodBinding overridden = null;
                if (methodBinding != null) {
                    overridden = Bindings.findOverriddenMethod(methodBinding, true);
                }
                if ((string = CodeGeneration.getMethodComment(cu, binding.getName(), methodDecl, overridden, String.valueOf('\n'))) != null && (p = this.addJavadocCommentProposal(label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_method_description, cu, 1, declaration.getStartPosition(), string)) != null) {
                    proposals.add(p);
                }
            } else if (declaration instanceof AbstractTypeDeclaration) {
                String label;
                T p;
                String[] params;
                String[] typeParamNames;
                String typeQualifiedName = Bindings.getTypeQualifiedName(binding);
                if (declaration instanceof TypeDeclaration) {
                    List typeParams = ((TypeDeclaration)declaration).typeParameters();
                    typeParamNames = new String[typeParams.size()];
                    int i = 0;
                    while (i < typeParamNames.length) {
                        typeParamNames[i] = ((TypeParameter)typeParams.get(i)).getName().getIdentifier();
                        ++i;
                    }
                    params = new String[]{};
                } else if (declaration instanceof RecordDeclaration) {
                    List recComps = ((RecordDeclaration)declaration).recordComponents();
                    params = new String[recComps.size()];
                    int i = 0;
                    while (i < params.length) {
                        params[i] = ((SingleVariableDeclaration)recComps.get(i)).getName().getIdentifier();
                        ++i;
                    }
                    List typeParams = ((RecordDeclaration)declaration).typeParameters();
                    typeParamNames = new String[typeParams.size()];
                    int i2 = 0;
                    while (i2 < typeParamNames.length) {
                        typeParamNames[i2] = ((TypeParameter)typeParams.get(i2)).getName().getIdentifier();
                        ++i2;
                    }
                } else {
                    typeParamNames = new String[]{};
                    params = new String[]{};
                }
                String string = CodeGeneration.getTypeComment(cu, typeQualifiedName, typeParamNames, params, String.valueOf('\n'));
                if (string != null && (p = this.addJavadocCommentProposal(label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_type_description, cu, 1, declaration.getStartPosition(), string)) != null) {
                    proposals.add(p);
                }
            } else if (declaration instanceof FieldDeclaration) {
                String label;
                T p;
                String comment = "/**\n *\n */\n";
                List fragments = ((FieldDeclaration)declaration).fragments();
                if (fragments != null && fragments.size() > 0) {
                    VariableDeclaration decl = (VariableDeclaration)fragments.get(0);
                    String fieldName = decl.getName().getIdentifier();
                    String typeName = binding.getName();
                    comment = CodeGeneration.getFieldComment(cu, typeName, fieldName, String.valueOf('\n'));
                }
                if (comment != null && (p = this.addJavadocCommentProposal(label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_field_description, cu, 1, declaration.getStartPosition(), comment)) != null) {
                    proposals.add(p);
                }
            } else if (declaration instanceof EnumConstantDeclaration) {
                EnumConstantDeclaration enumDecl = (EnumConstantDeclaration)declaration;
                String id = enumDecl.getName().getIdentifier();
                String comment = CodeGeneration.getFieldComment(cu, binding.getName(), id, String.valueOf('\n'));
                String label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_enumconst_description;
                T p = this.addJavadocCommentProposal(label, cu, 1, declaration.getStartPosition(), comment);
                if (p != null) {
                    proposals.add(p);
                }
            }
        }
    }

    protected abstract T addJavadocCommentProposal(String var1, ICompilationUnit var2, int var3, int var4, String var5);

    public void addRemoveJavadocTagProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        while (node != null && !(node instanceof TagElement)) {
            node = node.getParent();
        }
        if (node == null) {
            return;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
        rewrite.remove(node, null);
        String label = CorrectionMessages.JavadocTagsSubProcessor_removetag_description;
        T p = this.createRemoveJavadocTagProposals(label, context.getCompilationUnit(), rewrite, 5);
        if (p != null) {
            proposals.add(p);
        }
    }

    protected abstract T createRemoveJavadocTagProposals(String var1, ICompilationUnit var2, ASTRewrite var3, int var4);

    public void addRemoveDuplicateModuleJavadocTagProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node instanceof ModuleDeclaration) {
            if ((node = this.findModuleJavadocTag((ModuleDeclaration)node, problem)) == null) {
                return;
            }
            CompilationUnit cu = (CompilationUnit)((Javadoc)node.getParent()).getAlternateRoot();
            if (cu == null) {
                return;
            }
            int line = cu.getLineNumber(problem.getOffset());
            IJavaElement javaElement = cu.getJavaElement();
            if (javaElement == null) {
                return;
            }
            String lineDelimiter = StubUtility.getLineDelimiterUsed(javaElement);
            int start = cu.getPosition(line, 0) - lineDelimiter.length();
            int column = cu.getColumnNumber(node.getStartPosition());
            int length = node.getLength() + column + lineDelimiter.length();
            String label = Messages.format(CorrectionMessages.JavadocTagsSubProcessor_removeduplicatetag_description, ((TextElement)((TagElement)node).fragments().get(0)).getText().trim());
            T proposal = this.createRemoveDuplicateModuleJavadocTagProposal(label, context.getCompilationUnit(), start, length, "", 5);
            if (proposal != null) {
                proposals.add(proposal);
            }
        }
    }

    protected abstract T createRemoveDuplicateModuleJavadocTagProposal(String var1, ICompilationUnit var2, int var3, int var4, String var5, int var6);

    private ASTNode findModuleJavadocTag(ModuleDeclaration decl, IProblemLocation problem) {
        TagElement result = null;
        CompilationUnit cu = (CompilationUnit)decl.getParent();
        int problemLocationStart = problem.getOffset();
        Name moduleName = decl.getName();
        List comments = cu.getCommentList();
        block0: for (Comment comment : comments) {
            if (!(comment instanceof Javadoc) || comment.getStartPosition() + comment.getLength() >= moduleName.getStartPosition()) continue;
            Javadoc javadoc = (Javadoc)comment;
            List tags = javadoc.tags();
            for (TagElement tag : tags) {
                if (problemLocationStart <= tag.getStartPosition() || problemLocationStart >= tag.getStartPosition() + tag.getLength()) continue;
                result = tag;
                continue block0;
            }
        }
        return result;
    }

    public void addInvalidQualificationProposals(IInvocationContext context, IProblemLocation problem, Collection<T> proposals) {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (!(node instanceof Name)) {
            return;
        }
        Name name = (Name)node;
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof ITypeBinding)) {
            return;
        }
        ITypeBinding typeBinding = (ITypeBinding)binding;
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        rewrite.replace((ASTNode)name, (ASTNode)ast.newName(typeBinding.getQualifiedName()), null);
        String label = CorrectionMessages.JavadocTagsSubProcessor_qualifylinktoinner_description;
        T proposal = this.createInvalidQualificationProposal(label, context.getCompilationUnit(), rewrite, 5);
        if (proposal != null) {
            proposals.add(proposal);
        }
    }

    protected abstract T addAllMissingJavadocTagsProposal(String var1, ICompilationUnit var2, ASTNode var3, int var4);

    protected abstract T addMissingJavadocTagProposal(String var1, ICompilationUnit var2, ASTNode var3, ASTNode var4, int var5);

    protected abstract T addAllMissingModuleJavadocTagsProposal(String var1, ICompilationUnit var2, ModuleDeclaration var3, ASTNode var4, int var5);

    protected abstract T addMissingModuleJavadocTagProposal(String var1, ICompilationUnit var2, ModuleDeclaration var3, ASTNode var4, int var5);

    protected abstract T createInvalidQualificationProposal(String var1, ICompilationUnit var2, ASTRewrite var3, int var4);
}

