/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.synchronize.GitLazyResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.GitSubscriberResourceMappingContext;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.synchronize.DefaultGitSynchronizer;
import org.eclipse.egit.ui.internal.synchronize.GitModelSynchronize;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ModelAwareGitSynchronizer
extends DefaultGitSynchronizer {
    private ResourceMappingContext context;

    @Override
    public void compare(final IResource[] resources, final Repository repository, final String leftRev, final String rightRev, final boolean includeLocal, final IWorkbenchPage page) throws IOException {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        LinkedHashSet<IResource> resourceSet = new LinkedHashSet<IResource>(Arrays.asList(resources));
                        ModelAwareGitSynchronizer.this.context = ModelAwareGitSynchronizer.this.createResourceMappingContext(resourceSet, repository, leftRev, rightRev, includeLocal, monitor);
                        ModelAwareGitSynchronizer.super.compare(resources, repository, leftRev, rightRev, includeLocal, page);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.error(e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void compare(final IFile file, final Repository repository, final String leftPath, final String rightPath, final String leftRev, final String rightRev, final boolean includeLocal, final IWorkbenchPage page) throws IOException {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ModelAwareGitSynchronizer.this.context = ModelAwareGitSynchronizer.this.createResourceMappingContext(Collections.singleton(file), repository, leftRev, rightRev, includeLocal, monitor);
                        ModelAwareGitSynchronizer.super.compare(file, repository, leftPath, rightPath, leftRev, rightRev, includeLocal, page);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.error(e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean canCompareDirectly(IFile file) {
        ResourceMapping[] mappings;
        ResourceMapping[] resourceMappingArray = mappings = ResourceUtil.getResourceMappings((IResource)file, (ResourceMappingContext)this.context);
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            try {
                ResourceTraversal[] traversals;
                ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(this.context, null);
                int n3 = traversals.length;
                int n4 = 0;
                while (n4 < n3) {
                    ResourceTraversal traversal = resourceTraversalArray[n4];
                    IResource[] traversalResources = traversal.getResources();
                    if (traversalResources.length > 1 && Arrays.asList(traversalResources).contains(file)) {
                        return false;
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
            ++n2;
        }
        return true;
    }

    @Override
    protected void synchronize(IResource[] resources, Repository repository, String leftRev, String rightRev, boolean includeLocal) throws IOException {
        if (rightRev.equals("Index")) {
            this.openGitTreeCompare(resources, leftRev, "%%%INDEX%%%", includeLocal);
        } else {
            HashSet<IResource> includedResources = new HashSet<IResource>(Arrays.asList(resources));
            HashSet<ResourceMapping> allMappings = new HashSet<ResourceMapping>();
            HashSet<Object> newResources = new HashSet<IResource>(includedResources);
            do {
                HashSet<IResource> copy = newResources;
                newResources = new HashSet();
                for (IResource resource : copy) {
                    Assert.isNotNull((Object)resource);
                    ResourceMapping[] mappings = ResourceUtil.getResourceMappings((IResource)resource, (ResourceMappingContext)this.context);
                    allMappings.addAll(Arrays.asList(mappings));
                    newResources.addAll(this.collectResources(mappings));
                }
            } while (includedResources.addAll(newResources));
            if ("Index".equals(leftRev)) {
                mappings = allMappings.toArray(new ResourceMapping[0]);
                data = new GitSynchronizeData(repository, leftRev, rightRev, true, includedResources);
                GitModelSynchronize.launch(new GitSynchronizeDataSet(data), mappings);
            } else {
                mappings = allMappings.toArray(new ResourceMapping[0]);
                data = new GitSynchronizeData(repository, leftRev, rightRev, includeLocal, includedResources);
                GitModelSynchronize.launch(new GitSynchronizeDataSet(data), mappings);
            }
        }
    }

    protected ResourceMappingContext createResourceMappingContext(Set<IResource> resources, Repository repository, String leftRev, String rightRev, boolean includeLocal, IProgressMonitor monitor) {
        try {
            GitSynchronizeData gsd = new GitSynchronizeData(repository, leftRev, rightRev, includeLocal, resources);
            GitSynchronizeDataSet gsds = new GitSynchronizeDataSet(gsd);
            GitLazyResourceVariantTreeSubscriber subscriber = new GitLazyResourceVariantTreeSubscriber(gsds);
            subscriber.init(monitor);
            return new GitSubscriberResourceMappingContext((GitResourceVariantTreeSubscriber)subscriber, gsds);
        }
        catch (IOException e) {
            Activator.logError(e.getMessage(), e);
            return ResourceMappingContext.LOCAL_CONTEXT;
        }
    }

    private Set<IResource> collectResources(ResourceMapping[] mappings) {
        HashSet<IResource> result = new HashSet<IResource>();
        ResourceMapping[] resourceMappingArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceMapping mapping = resourceMappingArray[n2];
            try {
                ResourceTraversal[] traversals;
                ResourceTraversal[] resourceTraversalArray = traversals = mapping.getTraversals(this.context, (IProgressMonitor)new NullProgressMonitor());
                int n3 = traversals.length;
                int n4 = 0;
                while (n4 < n3) {
                    ResourceTraversal traversal = resourceTraversalArray[n4];
                    result.addAll(Arrays.asList(traversal.getResources()));
                    ++n4;
                }
            }
            catch (CoreException e) {
                Activator.logError(e.getMessage(), e);
            }
            ++n2;
        }
        return result;
    }
}

