/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.resources.ui.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.resources.ImportUtils;
import org.eclipse.rcptt.resources.WSUtils;
import org.eclipse.rcptt.resources.WorkspaceDataImporter;
import org.eclipse.rcptt.resources.ui.actions.WSAction;
import org.eclipse.rcptt.resources.ui.viewers.WorkspaceContentProvider;
import org.eclipse.rcptt.resources.ui.viewers.WorkspaceLabelProvider;
import org.eclipse.rcptt.ui.controls.SectionWithComposite;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.utils.DefaultTreeViewerEditStrategy;
import org.eclipse.rcptt.ui.utils.UIContentAdapter;
import org.eclipse.rcptt.ui.verification.BaseVerificationEditor;
import org.eclipse.rcptt.workspace.WSContainer;
import org.eclipse.rcptt.workspace.WSFile;
import org.eclipse.rcptt.workspace.WSFileLink;
import org.eclipse.rcptt.workspace.WSFolder;
import org.eclipse.rcptt.workspace.WSProject;
import org.eclipse.rcptt.workspace.WSProjectLink;
import org.eclipse.rcptt.workspace.WSResource;
import org.eclipse.rcptt.workspace.WSRoot;
import org.eclipse.rcptt.workspace.WorkspaceData;
import org.eclipse.rcptt.workspace.WorkspacePackage;
import org.eclipse.rcptt.workspace.WorkspaceVerification;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WorkspaceVerificationEditor
extends BaseVerificationEditor {
    private boolean corrected = false;
    private EContentAdapter adapter;
    private TreeViewer viewer;
    private final List<Button> buttons = new ArrayList<Button>();
    private WSAction.Remove removeAction;
    private WSAction.OpenFile openFileAction;

    public WorkspaceVerification getVerificationElement() {
        try {
            return (WorkspaceVerification)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    private static IFolder getFolder(IFile file) {
        return WorkspaceVerificationEditor.getFolder(file, "");
    }

    private static IFolder getFolder(IFile file, String postfix) {
        String folderName = file.getName().replaceAll("\\.", "");
        return file.getParent().getFolder((IPath)new Path("." + folderName + postfix));
    }

    private IResource[] getRelativeResources(Verification verification, IFile iFile) {
        IFile file = null;
        file = iFile == null ? Q7Utils.getLocation((NamedElement)verification) : iFile;
        if (file != null) {
            ArrayList<IFolder> result = new ArrayList<IFolder>();
            IFolder folder = WorkspaceVerificationEditor.getFolder(file);
            if (folder.exists()) {
                result.add(folder);
            }
            if ((folder = WorkspaceVerificationEditor.getFolder(file, "wc")).exists()) {
                result.add(folder);
            }
            return result.toArray(new IResource[result.size()]);
        }
        return new IFolder[0];
    }

    public void setElement(IQ7NamedElement context) {
        super.setElement(context);
        this.corrected = false;
        IResource[] resources = this.getRelativeResources((Verification)this.getVerificationElement(), null);
        if (resources != null && resources.length > 0) {
            IPersistenceModel model = PersistenceManager.getInstance().getModel(this.getVerificationElement().eResource());
            WorkspaceDataImporter importer = new WorkspaceDataImporter((WorkspaceData)this.getVerificationElement());
            EList projects = this.getVerificationElement().getContent().getProjects();
            for (WSProject wsProject : projects) {
                WSProject ownProject = WSUtils.getProject((WSRoot)this.getVerificationElement().getContent(), (String)wsProject.getName(), (boolean)true);
                ImportUtils.importFiles((WSFolder)ownProject, (EList)wsProject.getFiles(), (IPersistenceModel)model, (WorkspaceDataImporter)importer);
                ImportUtils.importFolders((WSFolder)ownProject, (EList)wsProject.getFolders(), (IPersistenceModel)model, (WorkspaceDataImporter)importer);
            }
            this.corrected = true;
        }
    }

    public void setSelectionAtLine(int line) {
    }

    public void save() throws CoreException {
        IResource[] resources;
        if (this.corrected && (resources = this.getRelativeResources((Verification)this.getVerificationElement(), null)) != null && resources.length > 0) {
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource iResource = iResourceArray[n2];
                if (iResource.exists()) {
                    iResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                ++n2;
            }
        }
        super.save();
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        Section section = toolkit.createSection(parent, 16706);
        section.setText("Workspace Options");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        Composite optionsComposite = toolkit.createComposite((Composite)section);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).numColumns(1).applyTo(optionsComposite);
        section.setClient((Control)optionsComposite);
        this.createOptionsControls(optionsComposite, toolkit);
        Section wsSection = new SectionWithComposite("Workspace", 322).numColumns(2).create(parent, toolkit);
        Composite wsComposite = (Composite)wsSection.getClient();
        this.createTree(wsComposite, toolkit);
        this.createPanel(wsComposite, toolkit);
        return section;
    }

    private void createOptionsControls(Composite parent, FormToolkit toolkit) {
        this.createAllowUncapturedControls(parent, toolkit);
        this.createIgnoreWhiteSpaceControls(parent, toolkit);
        this.createIgnoredLinesControls(parent, toolkit);
    }

    private void createAllowUncapturedControls(Composite parent, FormToolkit toolkit) {
        Button allowUncapturedFilesCheckbox = toolkit.createButton(parent, "Allow uncaptured files", 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)allowUncapturedFilesCheckbox);
        Label notAllowedPatternsLabel = new Label(parent, 0);
        notAllowedPatternsLabel.setText("Do not allow following uncaptured files or files in following folders (use a comma as separator, * = any string):");
        notAllowedPatternsLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        notAllowedPatternsLabel.setBackground(null);
        GridDataFactory.fillDefaults().span(2, 1).hint(100, -1).applyTo((Control)notAllowedPatternsLabel);
        Text notAllowedPatternsText = toolkit.createText(parent, "", 2048);
        notAllowedPatternsText.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)notAllowedPatternsText);
        IObservableValue allowUncapturedFiles = EMFObservables.observeValue((EObject)this.getVerificationElement(), (EStructuralFeature)WorkspacePackage.Literals.WORKSPACE_VERIFICATION__ALLOW_UNCAPTURED_FILES);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)notAllowedPatternsText), allowUncapturedFiles);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)notAllowedPatternsLabel), allowUncapturedFiles);
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)allowUncapturedFilesCheckbox), allowUncapturedFiles);
        IObservableValue notAllowedPatterns = EMFObservables.observeValue((EObject)this.getVerificationElement(), (EStructuralFeature)WorkspacePackage.Literals.WORKSPACE_VERIFICATION__NOT_ALLOWED_PATTERNS);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)notAllowedPatternsText), notAllowedPatterns);
    }

    private void createIgnoreWhiteSpaceControls(Composite parent, FormToolkit toolkit) {
        Button ignoreWhiteSpaceCheckbox = toolkit.createButton(parent, "Ignore white space", 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)ignoreWhiteSpaceCheckbox);
        IObservableValue ignoerWhiteSpaceCheckbox = EMFObservables.observeValue((EObject)this.getVerificationElement(), (EStructuralFeature)WorkspacePackage.Literals.WORKSPACE_VERIFICATION__IGNORE_WHITE_SPACE);
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)ignoreWhiteSpaceCheckbox), ignoerWhiteSpaceCheckbox);
    }

    private void createIgnoredLinesControls(Composite parent, FormToolkit toolkit) {
        Label ignoredLinePatternsLabel = new Label(parent, 0);
        ignoredLinePatternsLabel.setText("Ignore lines matched by following patterns (one regex per line):");
        ignoredLinePatternsLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        ignoredLinePatternsLabel.setBackground(null);
        GridDataFactory.fillDefaults().span(2, 1).hint(100, -1).applyTo((Control)ignoredLinePatternsLabel);
        Text ignoredLinePatternsText = toolkit.createText(parent, "", 2626);
        ignoredLinePatternsText.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 6).hint(100, -1).applyTo((Control)ignoredLinePatternsText);
        IObservableValue ignoredLinePatterns = EMFObservables.observeValue((EObject)this.getVerificationElement(), (EStructuralFeature)WorkspacePackage.Literals.WORKSPACE_VERIFICATION__IGNORED_LINES);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)ignoredLinePatternsText), ignoredLinePatterns);
    }

    private Tree createTree(Composite parent, FormToolkit toolkit) {
        Tree tree = new Tree(parent, 2050);
        GridDataFactory.fillDefaults().grab(true, true).hint(100, 50).applyTo((Control)tree);
        this.viewer = new TreeViewer(tree);
        TreeViewerEditor.create((TreeViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new DefaultTreeViewerEditStrategy((ColumnViewer)this.viewer), (int)1);
        this.viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)tree)});
        this.viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                TreeItem item = (TreeItem)element;
                WSResource res = (WSResource)item.getData();
                WSContainer parent = (WSContainer)res.eContainer();
                Set<String> allNames = WorkspaceVerificationEditor.this.getAllNames(parent);
                allNames.remove(res.getName());
                String newValue = (String)value;
                if (allNames.contains(newValue)) {
                    return;
                }
                if (newValue != null && !newValue.equals(res.getName())) {
                    try {
                        IPersistenceModel model = WorkspaceVerificationEditor.this.getElement().getPersistenceModel();
                        if (res instanceof WSFile) {
                            String oldName = ImportUtils.getName((WSFile)((WSFile)res));
                            res.setName(newValue);
                            String newName = ImportUtils.getName((WSFile)((WSFile)res));
                            model.rename(oldName, newName);
                        } else if (res instanceof WSContainer) {
                            ArrayList<String> oldNames = new ArrayList<String>();
                            List<WSFile> allFiles = WorkspaceVerificationEditor.this.findChildFiles((WSContainer)res);
                            for (WSFile wsFile : allFiles) {
                                oldNames.add(ImportUtils.getName((WSFile)wsFile));
                            }
                            res.setName(newValue);
                            int i = 0;
                            while (i < oldNames.size()) {
                                String oldName = (String)oldNames.get(i);
                                WSFile file = allFiles.get(i);
                                String newName = ImportUtils.getName((WSFile)file);
                                model.rename(oldName, newName);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        Q7UIPlugin.log((Throwable)e);
                    }
                }
            }

            public Object getValue(Object element, String property) {
                return ((WSResource)element).getName();
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        this.viewer.setColumnProperties(new String[]{"o"});
        this.viewer.setContentProvider((IContentProvider)new WorkspaceContentProvider());
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new WorkspaceLabelProvider(), decorator, null));
        this.viewer.setInput((Object)this.getVerificationElement());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)WorkspaceVerificationEditor.this.viewer.getSelection();
                Object[] res = sel.toArray();
                WSResource[] resources = new WSResource[res.length];
                int i = 0;
                while (i < res.length) {
                    resources[i] = (WSResource)res[i];
                    ++i;
                }
                WorkspaceVerificationEditor.this.setSelection(resources);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (WorkspaceVerificationEditor.this.openFileAction.isEnabled()) {
                    WorkspaceVerificationEditor.this.openFileAction.run();
                } else {
                    IStructuredSelection selection;
                    Object selectedNode;
                    TreeViewer viewer;
                    viewer.setExpandedState(selectedNode, !(viewer = (TreeViewer)event.getViewer()).getExpandedState(selectedNode = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()));
                }
            }
        });
        this.viewer.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if ('\u007f' == e.character && e.stateMask == 0 && WorkspaceVerificationEditor.this.removeAction.isEnabled()) {
                    WorkspaceVerificationEditor.this.removeAction.run();
                    e.doit = false;
                }
            }
        });
        this.adapter = new UIContentAdapter(){

            protected void changed(Notification notification) {
                if (WorkspaceVerificationEditor.this.viewer.getControl().isDisposed()) {
                    return;
                }
                WorkspaceVerificationEditor.this.viewer.refresh();
            }
        };
        this.getVerificationElement().eAdapters().add((Object)this.adapter);
        toolkit.adapt((Composite)tree);
        return tree;
    }

    protected List<WSFile> findChildFiles(WSContainer res) {
        ArrayList<WSFile> allFiles = new ArrayList<WSFile>();
        if (res instanceof WSFolder) {
            EList folders = ((WSFolder)res).getFolders();
            allFiles.addAll((Collection<WSFile>)((WSFolder)res).getFiles());
            for (WSFolder folder : folders) {
                allFiles.addAll(this.findChildFiles((WSContainer)folder));
            }
        }
        return allFiles;
    }

    private Composite createPanel(Composite parent, FormToolkit toolkit) {
        Composite panel = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().align(4, 1).applyTo((Control)panel);
        RowLayout layout = new RowLayout(512);
        layout.pack = false;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        panel.setLayout((Layout)layout);
        this.openFileAction = new WSAction.OpenFile();
        this.createButton(panel, toolkit, (WSAction)this.openFileAction);
        this.removeAction = new WSAction.Remove();
        this.createButton(panel, toolkit, (WSAction)this.removeAction);
        this.setSelection(null);
        return panel;
    }

    private void createButton(Composite parent, FormToolkit toolkit, final WSAction action) {
        action.setViewer(this.viewer);
        Button button = toolkit.createButton(parent, action.getText(), 8);
        button.setData((Object)action);
        Image image = action.getImageDescriptor().createImage();
        button.addDisposeListener(event -> image.dispose());
        button.setImage(image);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        this.buttons.add(button);
    }

    private void setSelection(WSResource[] selection) {
        for (Button button : this.buttons) {
            WSAction action = (WSAction)button.getData();
            action.setSelection(selection);
            button.setEnabled(action.isEnabled());
        }
    }

    public boolean isAutoSaveEnabled() {
        return true;
    }

    private Set<String> getAllNames(WSContainer parent) {
        HashSet<String> allNames;
        block6: {
            block5: {
                allNames = new HashSet<String>();
                if (!(parent instanceof WSFolder)) break block5;
                EList folders = ((WSFolder)parent).getFolders();
                EList files = ((WSFolder)parent).getFiles();
                EList fileLinks = ((WSFolder)parent).getFileLinks();
                for (WSFileLink link : fileLinks) {
                    allNames.add(link.getName());
                }
                for (WSFile wsFile : files) {
                    allNames.add(wsFile.getName());
                }
                for (WSFolder folder : folders) {
                    allNames.add(folder.getName());
                }
                break block6;
            }
            if (!(parent instanceof WSRoot)) break block6;
            EList projects = ((WSRoot)parent).getProjects();
            for (WSProject wsProject : projects) {
                allNames.add(wsProject.getName());
            }
            EList links = ((WSRoot)parent).getProjectLinks();
            for (WSProjectLink wsProjectLink : links) {
                allNames.add(wsProjectLink.getName());
            }
        }
        return allNames;
    }
}

