/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class OptionalRequireBundleResolution
extends AbstractManifestMarkerResolution {
    public OptionalRequireBundleResolution(int type, IMarker marker) {
        super(type, marker);
    }

    @Override
    protected void createChange(BundleModel model) {
        String bundleId = this.marker.getAttribute("bundleId", null);
        Bundle bundle = (Bundle)model.getBundle();
        RequireBundleHeader header = (RequireBundleHeader)bundle.getManifestHeader("Require-Bundle");
        if (header != null) {
            RequireBundleObject[] requiredBundles;
            RequireBundleObject[] requireBundleObjectArray = requiredBundles = header.getRequiredBundles();
            int n = requiredBundles.length;
            int n2 = 0;
            while (n2 < n) {
                RequireBundleObject requiredBundle = requireBundleObjectArray[n2];
                if (bundleId.equals(requiredBundle.getId())) {
                    requiredBundle.setOptional(true);
                }
                ++n2;
            }
        }
    }

    @Override
    public String getDescription() {
        return NLS.bind((String)PDEUIMessages.OptionalRequireBundleResolution_description, (Object)this.marker.getAttribute("bundleId", null));
    }

    public String getLabel() {
        return NLS.bind((String)PDEUIMessages.OptionalRequireBundleResolution_label, (Object)this.marker.getAttribute("bundleId", null));
    }
}

