/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.streams;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.rcptt.sherlock.core.SherlockCore;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.sherlock.core.streams.SherlockReportFormat;

public class SherlockReportSession {
    int index = 0;
    private File root;

    public SherlockReportSession(File root) {
        this.root = root;
        this.root.mkdirs();
    }

    public String write(Report report) {
        String postfix = "";
        if (report.getRoot().getName() != null) {
            postfix = SherlockCore.rlimitSize(SherlockCore.getID(report.getRoot().getName()), 10);
        }
        String id = String.format("%04d", this.index) + "_" + postfix + ".report";
        ++this.index;
        try {
            SherlockReportFormat.storeReport(report, new BufferedOutputStream(new FileOutputStream(new File(this.root, id))), true);
        }
        catch (IOException e) {
            SherlockCore.log(e);
            return null;
        }
        return id;
    }

    public Report getReport(String id) {
        File file = new File(this.root, id);
        if (!file.exists()) {
            return null;
        }
        try {
            return SherlockReportFormat.loadReport(new BufferedInputStream(new FileInputStream(file)), true, true);
        }
        catch (IOException e) {
            SherlockCore.log(e);
            return null;
        }
    }

    public void dispose() {
        File[] listFiles = this.root.listFiles();
        this.dispose(listFiles);
        this.root.delete();
    }

    private void dispose(File[] listFiles) {
        if (listFiles == null) {
            return;
        }
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.dispose(file.listFiles());
            }
            file.delete();
            ++n2;
        }
    }

    public void reinit() {
        this.dispose();
        this.root.mkdirs();
    }
}

