/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.navigator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.workspace.RcpttCore;

public class SearchFilter
extends ViewerFilter {
    private boolean enabled = false;
    private List<IQ7NamedElement> allowed = new ArrayList<IQ7NamedElement>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.enabled) {
            return true;
        }
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            List<IQ7NamedElement> list = this.allowed;
            synchronized (list) {
                IPath path;
                IPath containerPath;
                Iterator<IQ7NamedElement> iterator = this.allowed.iterator();
                do {
                    if (!iterator.hasNext()) {
                        return false;
                    }
                    IQ7NamedElement o = iterator.next();
                    path = o.getResource().getFullPath();
                } while (!(containerPath = container.getFullPath()).isPrefixOf(path));
                return true;
            }
        }
        if (!(element instanceof IFile)) return true;
        IQ7Element namedElement = RcpttCore.create((IResource)((IFile)element));
        if (namedElement == null) return false;
        List<IQ7NamedElement> list = this.allowed;
        synchronized (list) {
            return this.allowed.contains(namedElement);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<IQ7NamedElement> list = this.allowed;
        synchronized (list) {
            this.allowed.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IQ7NamedElement o) {
        List<IQ7NamedElement> list = this.allowed;
        synchronized (list) {
            this.allowed.add(o);
        }
    }
}

