/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.recording;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.core.VerificationType;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class WidgetPickerWindow
extends Dialog {
    private static final String SETTINGS_KEY = "WidgetPickerWindow";
    private final Shell shellToListenForClose;
    private final VerificationType type;

    public WidgetPickerWindow(Shell shellToListenForClose, Shell parentShell, VerificationType type) {
        super(parentShell);
        this.shellToListenForClose = shellToListenForClose;
        this.type = type;
        this.setShellStyle(0x4054 | (parentShell != null ? 32768 : 0));
    }

    protected Control createContents(Composite parent) {
        String prompt = this.type.getPrompt();
        Label welcomeLabel = new Label(parent, 64);
        GridDataFactory.fillDefaults().hint(334, -1).grab(true, true).applyTo((Control)welcomeLabel);
        welcomeLabel.setText(prompt == null ? "Please pick a widget for verification." : this.type.getPrompt());
        Label cancelLabel = new Label(parent, 0);
        GridDataFactory.fillDefaults().indent(0, 16).applyTo((Control)cancelLabel);
        cancelLabel.setText("Waiting for selection. Press Esc to cancel.");
        Button cancelButton = new Button(parent, 8);
        cancelButton.setText("Cancel");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)cancelButton);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WidgetPickerWindow.this.close();
            }
        });
        parent.getShell().pack();
        parent.getShell().setLocation(this.getInitialLocation(this.getInitialSize()));
        return parent;
    }

    protected Point getInitialLocation(Point location) {
        if (this.hasDialogBoundsSettings()) {
            return super.getInitialLocation(location);
        }
        return new Point(0, 0);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings root = Q7UIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = root.getSection(SETTINGS_KEY);
        if (section == null) {
            section = root.addNewSection(SETTINGS_KEY);
        }
        return section;
    }

    private boolean hasDialogBoundsSettings() {
        IDialogSettings root = Q7UIPlugin.getDefault().getDialogSettings();
        return root.getSection(SETTINGS_KEY) != null;
    }

    protected void configureShell(final Shell newShell) {
        super.configureShell(newShell);
        GridLayoutFactory.fillDefaults().equalWidth(true).numColumns(1).spacing(8, 8).margins(8, 8).applyTo((Composite)newShell);
        this.shellToListenForClose.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                WidgetPickerWindow.this.close();
            }
        });
        final Listener filter = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof Control && ((Control)event.widget).getShell() == newShell && event.keyCode == 27) {
                    WidgetPickerWindow.this.close();
                }
            }
        };
        newShell.getDisplay().addFilter(1, filter);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                newShell.getDisplay().removeFilter(1, filter);
            }
        });
    }
}

