/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.commons.Q7ContainerSelectionGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class LocationSelectionDialog
extends Dialog {
    Q7ContainerSelectionGroup containerSelectionGroup;
    private String initialSelection;
    protected IPath location;

    public LocationSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.LocationSelectionDialog_Title);
        newShell.setImage(Images.getImageDescriptor("icons/q7.gif").createImage());
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 400;
        data.heightHint = 300;
        content.setLayoutData((Object)data);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                LocationSelectionDialog.this.location = LocationSelectionDialog.this.containerSelectionGroup.getContainerFullPath();
            }
        };
        this.containerSelectionGroup = new Q7ContainerSelectionGroup(content, listener, Messages.LocationSelectionDialog_Q7ContainerSelectionGroupMsg, 400, 300);
        this.containerSelectionGroup.setLayoutData(new GridData(4, 4, true, true));
        this.setLocation(this.initialSelection);
        this.updateEnablement(false);
        return content;
    }

    private void updateEnablement(boolean state) {
        if (this.buttonBar != null) {
            Button button = this.getButton(0);
            button.setEnabled(state);
        }
    }

    public void setLocation(String location) {
        if (this.containerSelectionGroup == null) {
            this.initialSelection = location;
            return;
        }
        if (location != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            Path path = new Path(location);
            if (!path.isEmpty()) {
                IPath folderPath = path.removeFirstSegments(1);
                String projectSegment = path.segment(0);
                if (projectSegment != null) {
                    IProject container = root.getProject(projectSegment);
                    if (!folderPath.isEmpty()) {
                        container = container.getFolder(folderPath);
                    }
                    if (container != null && container.exists()) {
                        this.containerSelectionGroup.setSelectedContainer((IContainer)container);
                    }
                }
            }
        }
    }

    public String getLocation() {
        if (this.location != null) {
            return this.location.toString();
        }
        return null;
    }
}

