/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.p2;

import java.net.URI;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class P2Fetcher {
    public static RepositoryContent fetchAvailableUnits(URI repositoryLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)31);
        BundleContext context = FrameworkUtil.getBundle(P2Fetcher.class).getBundleContext();
        ServiceReference sr = context.getServiceReference(IProvisioningAgentProvider.class);
        try {
            IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)context.getService(sr);
            IProvisioningAgent agent = agentProvider.createAgent(null);
            IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.class);
            IMetadataRepository repository = manager.loadRepository(repositoryLocation, (IProgressMonitor)subMonitor.split(30));
            IQueryResult allUnits = repository.query(QueryUtil.ALL_UNITS, (IProgressMonitor)subMonitor.split(1));
            List<URI> children = P2Fetcher.allChildren(repository, manager).toList();
            RepositoryContent repositoryContent = new RepositoryContent((IQueryResult<IInstallableUnit>)allUnits, children);
            return repositoryContent;
        }
        finally {
            context.ungetService(sr);
        }
    }

    private static Stream<URI> allChildren(IRepository<?> repository, IMetadataRepositoryManager manager) {
        if (repository instanceof ICompositeRepository) {
            ICompositeRepository composite = (ICompositeRepository)repository;
            return composite.getChildren().stream().flatMap(uri -> {
                try {
                    return Stream.concat(Stream.of(uri), P2Fetcher.allChildren(manager.loadRepository(uri, null), manager));
                }
                catch (ProvisionException e) {
                    return Stream.of(uri);
                }
            });
        }
        return Stream.empty();
    }

    public record RepositoryContent(IQueryResult<IInstallableUnit> units, List<URI> children) {
    }
}

