/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.storage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.attributes.Filtering;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.internal.CompareCoreUtils;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;
import org.eclipse.osgi.util.NLS;

public class GitBlobStorage
implements IEncodedStorage,
GitInfo {
    protected final Repository db;
    protected final String path;
    protected final ObjectId blobId;
    private final DirCacheCheckout.CheckoutMetadata metadata;
    private final boolean isGitlink;
    private String charset;

    @Deprecated
    public GitBlobStorage(Repository repository, String path, ObjectId blob) {
        this(repository, path, blob, null);
    }

    public GitBlobStorage(Repository repository, String path, ObjectId blob, DirCacheCheckout.CheckoutMetadata metadata) {
        this(repository, path, blob, metadata, false);
    }

    public GitBlobStorage(Repository repository, String path, ObjectId blob, DirCacheCheckout.CheckoutMetadata metadata, boolean isGitlink) {
        this.db = repository;
        this.path = path;
        this.blobId = blob;
        this.metadata = metadata;
        this.isGitlink = isGitlink;
    }

    @Override
    public Repository getRepository() {
        return this.db;
    }

    @Override
    public String getGitPath() {
        return this.path;
    }

    @Override
    public AnyObjectId getCommitId() {
        return null;
    }

    @Override
    public GitInfo.Source getSource() {
        return null;
    }

    public InputStream getContents() throws CoreException {
        try {
            return this.open();
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.BlobStorage_errorReadingBlob, (Object)this.blobId.name(), (Object)this.path), e));
        }
    }

    private InputStream open() throws IOException, CoreException, IncorrectObjectTypeException {
        if (this.blobId == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        if (this.isGitlink) {
            return new ByteArrayInputStream(Constants.encode((String)this.blobId.name()));
        }
        try {
            ObjectStream objectInputStream;
            Object filteredInputStream = objectInputStream = this.db.open((AnyObjectId)this.blobId, 3).openStream();
            if (this.metadata != null) {
                filteredInputStream = Filtering.filter(this.db, this.path, (InputStream)objectInputStream, this.metadata.smudgeFilterCommand);
            }
            CoreConfig.EolStreamType streamType = this.metadata != null && this.metadata.eolStreamType != null ? this.metadata.eolStreamType : (((WorkingTreeOptions)this.db.getConfig().get(WorkingTreeOptions.KEY)).getAutoCRLF() == CoreConfig.AutoCRLF.TRUE ? CoreConfig.EolStreamType.AUTO_CRLF : CoreConfig.EolStreamType.DIRECT);
            return EolStreamTypeUtil.wrapInputStream((InputStream)filteredInputStream, (CoreConfig.EolStreamType)streamType, (boolean)true);
        }
        catch (MissingObjectException notFound) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.BlobStorage_blobNotFound, (Object)this.blobId.name(), (Object)this.path), notFound));
        }
    }

    public IPath getFullPath() {
        return Path.fromPortableString((String)this.path);
    }

    public String getName() {
        int last = this.path.lastIndexOf(47);
        return last >= 0 ? this.path.substring(last + 1) : this.path;
    }

    public boolean isReadOnly() {
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.blobId, this.db, this.path});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GitBlobStorage other = (GitBlobStorage)obj;
        if (this.blobId == null ? other.blobId != null : !this.blobId.equals((AnyObjectId)other.blobId)) {
            return false;
        }
        if (this.db == null ? other.db != null : !this.db.equals(other.db)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return this.isGitlink == other.isGitlink;
    }

    public IPath getAbsolutePath() {
        if (this.db.isBare()) {
            return null;
        }
        return new Path(this.db.getWorkTree().getAbsolutePath() + File.separatorChar + this.path);
    }

    public String getCharset() throws CoreException {
        if (this.charset == null) {
            this.charset = CompareCoreUtils.getResourceEncoding(this.db, this.path);
            if (this.charset == null) {
                this.charset = ResourcesPlugin.getEncoding();
            }
        }
        return this.charset;
    }
}

