/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;

public class PluginFactoryContainer
extends FactoryContainer {
    private final String id;
    private final boolean enableDefault;

    public PluginFactoryContainer(String pluginId, boolean enableDefault) {
        this.id = pluginId;
        this.enableDefault = enableDefault;
    }

    public void addFactoryName(String factoryName, String serviceName) {
        try {
            this.getFactoryNames().put(factoryName, serviceName);
        }
        catch (IOException ioe) {
            AptPlugin.log(ioe, "IOException reading a plugin");
        }
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    protected Map<String, String> loadFactoryNames() {
        return new LinkedHashMap<String, String>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public boolean getEnableDefault() {
        return this.enableDefault;
    }

    @Override
    public FactoryContainer.FactoryType getType() {
        return FactoryContainer.FactoryType.PLUGIN;
    }
}

